"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),sequelize_1=require("sequelize");exports.metadata={summary:"Get ICO Offering Statistics",description:"Retrieves count statistics for ICO token offerings across all statuses (ACTIVE, UPCOMING, COMPLETED).",operationId:"getIcoOfferingStats",tags:["ICO","Offerings"],logModule:"ICO",logTitle:"Get ICO Offer Stats",responses:{200:{description:"ICO offering statistics retrieved successfully.",content:{"application/json":{schema:{type:"object",properties:{active:{type:"number",description:"Total count of active offerings"},upcoming:{type:"number",description:"Total count of upcoming offerings"},completed:{type:"number",description:"Total count of completed offerings (SUCCESS + FAILED)"}}}}}},500:{description:"Internal Server Error."}}};exports.default=async e=>{try{const{ctx:t}=e||{};null==t||t.step("Fetching ICO offering statistics");const[s,o,r]=await Promise.all([db_1.models.icoTokenOffering.count({where:{status:"ACTIVE"}}),db_1.models.icoTokenOffering.count({where:{status:"UPCOMING"}}),db_1.models.icoTokenOffering.count({where:{status:{[sequelize_1.Op.in]:["SUCCESS","FAILED"]}}})]);null==t||t.success("ICO offering statistics retrieved successfully");return{active:s,upcoming:o,completed:r}}catch(e){console.error("Error in getIcoOfferingStats:",e);throw e}};