"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const utils_1=require("./utils"),db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize");exports.metadata={summary:"Get Portfolio Performance Data",description:"Generates historical performance data and calculates metrics for the user's ICO portfolio based on real transactions and token offering data. The timeframe (e.g. '1W', '1M', '3M', '1Y', 'ALL') specifies the period to compute over. Additionally, a metric for rejected investments is provided.",operationId:"getPortfolioPerformanceData",tags:["ICO","Portfolio","Performance"],logModule:"ICO",logTitle:"Get Portfolio Performance",requiresAuth:!0,parameters:[{index:0,name:"timeframe",in:"query",required:!1,schema:{type:"string",description:"Timeframe for performance data (e.g. '1W', '1M', '3M', '1Y', 'ALL')."}}],responses:{200:{description:"Portfolio performance data retrieved successfully.",content:{"application/json":{schema:{type:"object",properties:{performanceData:{type:"array",description:"Array of daily performance data points."},metrics:{type:"object",description:"Calculated portfolio performance metrics.",properties:{initialValue:{type:"number"},currentValue:{type:"number"},absoluteChange:{type:"number"},percentageChange:{type:"number"},bestDay:{type:"object",properties:{date:{type:"string"},change:{type:"number"}}},worstDay:{type:"object",properties:{date:{type:"string"},change:{type:"number"}}},volatility:{type:"number"},sharpeRatio:{type:"number"},rejectedInvested:{type:"number"},allocation:{type:"object",properties:{byToken:{type:"array",items:{type:"object",properties:{name:{type:"string"},percentage:{type:"number"}}}}}}}}}}}}},401:{description:"Unauthorized."},500:{description:"Internal Server Error."}}};exports.default=async e=>{const{user:t,query:r,ctx:a}=e;null==a||a.step("Fetching get portfolio performance");if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});let o;switch(r.timeframe||"1M"){case"1W":o=7;break;case"1M":default:o=30;break;case"3M":o=90;break;case"1Y":o=365;break;case"ALL":o=730}const i=new Date,s=new Date(i);s.setDate(i.getDate()-o);const n=await(0,utils_1.getUserPortfolioHistory)(t.id,s,i,a);if(!n||0===n.length)throw(0,error_1.createError)({statusCode:404,message:"No performance data available"});const c=n[0].value,l=n[n.length-1].value,p=l-c,u=c>0?p/c*100:0;let d=Number.NEGATIVE_INFINITY,m="",f=Number.POSITIVE_INFINITY,y="";const b=[];for(let e=1;e<n.length;e++){const t=n[e-1].value,r=n[e].value,a=t>0?(r-t)/t:0;b.push(a);if(a>d){d=a;m=n[e].date}if(a<f){f=a;y=n[e].date}}let g=0,h=0;if(b.length>0){const e=b.reduce((e,t)=>e+t,0)/b.length,t=b.reduce((t,r)=>t+Math.pow(r-e,2),0)/b.length;g=Math.sqrt(t)*Math.sqrt(252)*100;const r=c>0?Math.pow(l/c,365/o)-1:0;h=0!==g?(r-.02)/(g/100):0}const{allocationByToken:v}=await(0,utils_1.getAllocationByToken)(t.id,i,a),I={initialValue:c,currentValue:l,absoluteChange:p,percentageChange:u,bestDay:{date:m,change:100*d},worstDay:{date:y,change:100*f},volatility:g,sharpeRatio:h,allocation:{byToken:v},rejectedInvested:(await db_1.models.icoTransaction.findAll({where:{userId:t.id,createdAt:{[sequelize_1.Op.lte]:i},status:"REJECTED"},raw:!0})).reduce((e,t)=>e+t.amount*t.price,0)};null==a||a.success("Get Portfolio Performance retrieved successfully");return{performanceData:n,metrics:I}};