"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),query_1=require("@b/utils/query"),constants_1=require("@b/utils/constants"),utils_1=require("../../../finance/transaction/utils"),error_1=require("@b/utils/error");exports.metadata={summary:"Lists ICO transactions with optional filters",operationId:"listIcoTransactions",tags:["User","Ico","Transaction"],logModule:"ICO",logTitle:"Get ICO Transactions",parameters:constants_1.crudParameters,responses:{200:{description:"Paginated list of ICO transactions retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{data:{type:"array",items:{type:"object",properties:utils_1.baseTransactionSchema}},pagination:constants_1.paginationSchema}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Transactions"),500:query_1.serverErrorResponse},requiresAuth:!0};exports.default=async e=>{const{user:t,query:s,ctx:r}=e;null==r||r.step("Fetching get ico transactions");if(!t)throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const a=await(0,query_1.getFiltered)({model:db_1.models.icoTransaction,where:{userId:t.id},query:s,sortField:s.sortField||"createdAt",includeModels:[{model:db_1.models.icoTokenOffering,as:"offering",attributes:["id","name","symbol","tokenPrice","targetAmount"]}]});null==r||r.success("Get ICO Transactions retrieved successfully");return a};