"use strict";async function createVestingSchedule(e,t){const a=await db_1.sequelize.transaction();try{const s=await db_1.models.icoTransaction.findByPk(e,{include:[{model:db_1.models.icoTokenOffering,as:"offering"}],transaction:a});if(!s)throw(0,error_1.createError)({statusCode:404,message:"Transaction not found"});let n=null;"MILESTONE"===t.type&&t.milestones&&(n=t.milestones.map(e=>({date:e.date,percentage:e.percentage,amount:s.amount*(e.percentage/100)})));const o=await db_1.models.icoTokenVesting.create({transactionId:s.id,userId:s.userId,offeringId:s.offeringId,totalAmount:s.amount,releasedAmount:0,vestingType:t.type,startDate:t.startDate,endDate:t.endDate,cliffDuration:t.cliffDuration,releaseSchedule:n,status:"ACTIVE"},{transaction:a});if("MILESTONE"===t.type&&n)for(const e of n)await db_1.models.icoTokenVestingRelease.create({vestingId:o.id,amount:e.amount,releaseDate:e.date,status:"PENDING"},{transaction:a});await a.commit();return o}catch(e){await a.rollback();throw e}}async function calculateVestedAmount(e){const t=await db_1.models.icoTokenVesting.findByPk(e);if(!t)return 0;const a=new Date;if(a<t.startDate)return 0;if(a>=t.endDate)return t.totalAmount;switch(t.vestingType){case"LINEAR":if(t.cliffDuration){const e=new Date(t.startDate);e.setDate(e.getDate()+t.cliffDuration);if(a<e)return 0}const e=t.endDate.getTime()-t.startDate.getTime(),s=(a.getTime()-t.startDate.getTime())/e;return t.totalAmount*s;case"CLIFF":const n=new Date(t.startDate);n.setDate(n.getDate()+(t.cliffDuration||365));return a>=n?t.totalAmount:0;case"MILESTONE":if(!t.releaseSchedule)return 0;let o=0;for(const e of t.releaseSchedule)new Date(e.date)<=a&&(o+=e.amount);return o;default:return 0}}async function processVestingReleases(){const e=await db_1.sequelize.transaction();try{const t=new Date,a=await db_1.models.icoTokenVestingRelease.findAll({where:{status:"PENDING",releaseDate:{[sequelize_1.Op.lte]:t}},include:[{model:db_1.models.icoTokenVesting,as:"vesting",where:{status:"ACTIVE"},include:[{model:db_1.models.icoTransaction,as:"transaction",include:[{model:db_1.models.icoTokenOffering,as:"offering"}]}]}],transaction:e});for(const t of a)try{await t.update({status:"PROCESSING"},{transaction:e});await t.vesting.update({releasedAmount:t.vesting.releasedAmount+t.amount},{transaction:e});await(0,notifications_1.createNotification)({userId:t.vesting.userId,relatedId:t.vesting.offeringId,type:"investment",title:"Vested Tokens Available",message:`${t.amount} ${t.vesting.transaction.offering.symbol} tokens are now available for release`,details:`Your vested tokens from ${t.vesting.transaction.offering.name} are ready to be claimed.`,link:"/ico/dashboard?tab=vesting",actions:[{label:"Claim Tokens",link:`/ico/vesting/${t.vestingId}/claim`,primary:!0}]});await db_1.models.icoAdminActivity.create({type:"VESTING_RELEASE",offeringId:t.vesting.offeringId,offeringName:t.vesting.transaction.offering.name,adminId:null,details:JSON.stringify({vestingId:t.vestingId,releaseId:t.id,amount:t.amount,userId:t.vesting.userId})},{transaction:e})}catch(a){console_1.logger.error("ICO_VESTING",`Failed to process vesting release ${t.id}`,a);await t.update({status:"FAILED",notes:a.message},{transaction:e})}const s=await db_1.models.icoTokenVesting.findAll({where:{status:"ACTIVE",endDate:{[sequelize_1.Op.lte]:t}},transaction:e});for(const t of s)t.releasedAmount>=t.totalAmount&&await t.update({status:"COMPLETED"},{transaction:e});await e.commit()}catch(t){await e.rollback();console_1.logger.error("ICO_VESTING","Error processing vesting releases",t);throw t}}async function claimVestedTokens(e,t,a,s){const n=await db_1.sequelize.transaction();try{const o=await db_1.models.icoTokenVesting.findOne({where:{id:e,userId:t,status:"ACTIVE"},include:[{model:db_1.models.icoTokenVestingRelease,as:"releases",where:{status:"PROCESSING"}}],transaction:n});if(!o)throw(0,error_1.createError)({statusCode:404,message:"Vesting not found or access denied"});for(const e of o.releases)await e.update({status:"COMPLETED",transactionHash:s,notes:`Claimed to wallet: ${a}`},{transaction:n});await n.commit();await(0,notifications_1.createNotification)({userId:t,relatedId:o.offeringId,type:"investment",title:"Vested Tokens Claimed",message:"Your vested tokens have been successfully claimed",details:`Transaction hash: ${s}`,link:"/ico/dashboard?tab=vesting"})}catch(e){await n.rollback();throw e}}async function getVestingScheduleForUser(e){const t=await db_1.models.icoTokenVesting.findAll({where:{userId:e,status:{[sequelize_1.Op.in]:["ACTIVE","COMPLETED"]}},include:[{model:db_1.models.icoTokenVestingRelease,as:"releases"},{model:db_1.models.icoTransaction,as:"transaction",include:[{model:db_1.models.icoTokenOffering,as:"offering",attributes:["name","symbol"]}]}],order:[["startDate","ASC"]]});return await Promise.all(t.map(async e=>{const t=await calculateVestedAmount(e.id);return{...e.get({plain:!0}),vestedAmount:t,availableToClaim:t-e.releasedAmount}}))}Object.defineProperty(exports,"__esModule",{value:!0});exports.createVestingSchedule=createVestingSchedule;exports.calculateVestedAmount=calculateVestedAmount;exports.processVestingReleases=processVestingReleases;exports.claimVestedTokens=claimVestedTokens;exports.getVestingScheduleForUser=getVestingScheduleForUser;const db_1=require("@b/db"),sequelize_1=require("sequelize"),notifications_1=require("@b/utils/notifications"),console_1=require("@b/utils/console"),error_1=require("@b/utils/error");