"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),sequelize_1=require("sequelize"),query_1=require("@b/utils/query"),error_1=require("@b/utils/error");exports.metadata={summary:"Get P2P Trading Activity",description:"Retrieves recent trading activity for the authenticated user.",operationId:"getP2PTradingActivity",tags:["P2P","Dashboard"],logModule:"P2P",logTitle:"Get trading activity",responses:{200:{description:"Trading activity retrieved successfully."},401:query_1.unauthorizedResponse,500:query_1.serverErrorResponse},requiresAuth:!0};exports.default=async e=>{const{user:t,ctx:r}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==r||r.step("Fetching recent trades");try{const e=(await db_1.models.p2pTrade.findAll({where:{[sequelize_1.Op.or]:[{buyerId:t.id},{sellerId:t.id}]},include:[{model:db_1.models.p2pOffer,as:"offer",attributes:["currency"]},{model:db_1.models.p2pPaymentMethod,as:"paymentMethodDetails",attributes:["name"]}],order:[["updatedAt","DESC"]],limit:10})).map(e=>{var r,a;const i=e.get({plain:!0}),s=i.buyerId===t.id,d=s?"BUY":"SELL";return{id:i.id,type:d,status:i.status,amount:i.amount,currency:i.currency||(null===(r=i.offer)||void 0===r?void 0:r.currency)||"Unknown",total:i.total,paymentMethodName:(null===(a=i.paymentMethodDetails)||void 0===a?void 0:a.name)||"Unknown",counterpartyId:s?i.sellerId:i.buyerId,timestamp:i.updatedAt,createdAt:i.createdAt}});null==r||r.success(`Retrieved ${e.length} activity records`);return e}catch(e){null==r||r.fail(e.message||"Failed to retrieve trading activity");throw(0,error_1.createError)({statusCode:500,message:"Internal Server Error: "+e.message})}};