"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),query_1=require("@b/utils/query"),sequelize_1=require("sequelize"),utils_1=require("@b/api/finance/currency/utils"),console_1=require("@b/utils/console"),error_1=require("@b/utils/error");exports.metadata={summary:"Get P2P Dashboard Data",description:"Retrieves dashboard data including notifications, portfolio, stats, trading activity, and transactions for the authenticated user.",operationId:"getP2PDashboardData",tags:["P2P","Dashboard"],logModule:"P2P",logTitle:"Get dashboard data",responses:{200:{description:"Dashboard data retrieved successfully."},401:query_1.unauthorizedResponse,500:query_1.serverErrorResponse},requiresAuth:!0};exports.default=async e=>{const{user:t,ctx:r}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==r||r.step("Initializing dashboard data fetch");try{const e=0;let a=null,l=null,o=[],i=[];null==r||r.step("Fetching user wallets");let s=[];try{s=await db_1.models.wallet.findAll({where:{userId:t.id,type:{[sequelize_1.Op.in]:["FIAT","SPOT","ECO"]}},attributes:["id","type","currency","balance","inOrder","status"],raw:!0})}catch(e){console_1.logger.error("P2P",`Error fetching user wallets: ${e}`);s=[]}null==r||r.step("Calculating portfolio data");try{a=await db_1.models.p2pTrade.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("total")),"totalValue"]],where:{status:"COMPLETED",[sequelize_1.Op.or]:[{buyerId:t.id},{sellerId:t.id}]},raw:!0})}catch(e){console_1.logger.error("P2P",`Error fetching portfolio data: ${e}`);a={totalValue:0}}null==r||r.step("Calculating dashboard statistics");try{const e=await db_1.models.p2pTrade.findOne({attributes:[[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("id")),"tradeCount"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)("CASE WHEN status = 'COMPLETED' THEN 1 END")),"completedCount"]],where:{[sequelize_1.Op.or]:[{buyerId:t.id},{sellerId:t.id}]},raw:!0}),r=parseInt((null==e?void 0:e.tradeCount)||"0"),o=parseInt((null==e?void 0:e.completedCount)||"0"),i=r>0?(o/r*100).toFixed(1):"0";let n=0;for(const e of s)try{const t=parseFloat(e.balance||"0")||0,r=e.type||"SPOT";if(t<=0)continue;let a=1;try{"USD"===e.currency?a=1:"FIAT"===r?a=await(0,utils_1.getFiatPriceInUSD)(e.currency)||1:"SPOT"===r||"FUTURES"===r?a=await(0,utils_1.getSpotPriceInUSD)(e.currency)||0:"ECO"===r&&(a=await(0,utils_1.getEcoPriceInUSD)(e.currency)||0)}catch(t){console_1.logger.warn("P2P",`Failed to fetch price for ${e.currency} (${r}): ${t.message||t}`);a="USD"===e.currency?1:0}n+=t*a}catch(e){console_1.logger.warn("P2P",`Error calculating wallet balance: ${e.message||e}`)}l=[{title:"Total Balance",value:`$${n.toFixed(2)}`,change:"+0.0% from last month",changeType:"neutral",icon:"wallet",gradient:"from-blue-500 to-blue-700"},{title:"Trading Volume",value:`$${(null==a?void 0:a.totalValue)||0}`,change:"+0.0% from last month",changeType:"neutral",icon:"trending-up",gradient:"from-green-500 to-green-700"},{title:"Active Trades",value:r.toString(),change:`${o} completed`,changeType:"neutral",icon:"bar-chart",gradient:"from-violet-500 to-violet-700"},{title:"Success Rate",value:`${i}%`,change:`Based on ${r} trades`,changeType:"neutral",icon:"shield-check",gradient:"from-amber-500 to-amber-700"}]}catch(e){console_1.logger.error("P2P",`Error fetching stats data: ${e}`);l=[]}null==r||r.step("Fetching trading activity");try{const e=await db_1.models.p2pTrade.findAll({where:{[sequelize_1.Op.or]:[{buyerId:t.id},{sellerId:t.id}]},include:[{model:db_1.models.p2pOffer,as:"offer",attributes:["currency"]},{model:db_1.models.p2pPaymentMethod,as:"paymentMethodDetails",attributes:["name"]},{model:db_1.models.user,as:"buyer",attributes:["id","firstName","lastName","avatar"]},{model:db_1.models.user,as:"seller",attributes:["id","firstName","lastName","avatar"]}],order:[["updatedAt","DESC"]],limit:10});o=await Promise.all(e.map(async e=>{var r,a;const l=e.get({plain:!0}),o=l.buyerId===t.id,i=o?"BUY":"SELL",s=o?l.seller:l.buyer;let n=0;try{const e=await db_1.models.p2pReview.findAll({where:{reviewedId:null==s?void 0:s.id},attributes:["rating"],raw:!0});if(e.length>0){const t=e.reduce((e,t)=>e+(t.rating||0),0);n=Math.round(t/e.length*10)/10}}catch(e){}return{id:l.id,type:i,status:l.status,amount:l.amount,currency:l.currency||(null===(r=l.offer)||void 0===r?void 0:r.currency)||"Unknown",total:l.total,paymentMethodName:(null===(a=l.paymentMethodDetails)||void 0===a?void 0:a.name)||"Unknown",counterpartyId:null==s?void 0:s.id,counterpartyName:s&&`${s.firstName||""} ${s.lastName||""}`.trim()||"Unknown",counterpartyAvatar:null==s?void 0:s.avatar,counterpartyRating:n,timestamp:l.updatedAt,createdAt:l.createdAt}}))}catch(e){console_1.logger.error("P2P",`Error fetching activity data: ${e}`);o=[]}null==r||r.step("Fetching recent transactions");try{i=await db_1.models.p2pTrade.findAll({where:{[sequelize_1.Op.or]:[{buyerId:t.id},{sellerId:t.id}]},order:[["createdAt","DESC"]],limit:10,raw:!0})}catch(e){console_1.logger.error("P2P",`Error fetching transactions data: ${e}`);i=[]}null==r||r.success("Dashboard data retrieved successfully");return{notifications:e,portfolio:a||{totalValue:0},stats:l||[],tradingActivity:o||[],transactions:i||[],wallets:s.map(e=>({id:e.id,type:e.type,currency:e.currency,balance:parseFloat(e.balance||0),inOrder:parseFloat(e.inOrder||0),availableBalance:parseFloat(e.balance||0)-parseFloat(e.inOrder||0),status:e.status}))}}catch(e){null==r||r.fail(e.message||"Failed to retrieve dashboard data");throw(0,error_1.createError)({statusCode:500,message:"Internal Server Error: "+e.message})}};