"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),sequelize_1=require("sequelize"),query_1=require("@b/utils/query"),utils_1=require("@b/api/finance/currency/utils"),error_1=require("@b/utils/error");exports.metadata={summary:"Get P2P Portfolio Data",description:"Retrieves the portfolio summary for the authenticated user.",operationId:"getP2PPortfolioData",tags:["P2P","Dashboard"],logModule:"P2P",logTitle:"Get portfolio data",responses:{200:{description:"Portfolio data retrieved successfully."},401:query_1.unauthorizedResponse,500:query_1.serverErrorResponse},requiresAuth:!0};exports.default=async e=>{const{user:t,ctx:r}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==r||r.step("Fetching completed trade volume");try{const e=await db_1.models.p2pTrade.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("total")),"completedVolume"]],where:{status:"COMPLETED",[sequelize_1.Op.or]:[{buyerId:t.id},{sellerId:t.id}]},raw:!0});null==r||r.step("Fetching active trades value");const a=await db_1.models.p2pTrade.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("total")),"activeVolume"]],where:{status:{[sequelize_1.Op.notIn]:["COMPLETED","CANCELLED","REFUNDED"]},[sequelize_1.Op.or]:[{buyerId:t.id},{sellerId:t.id}]},raw:!0});null==r||r.step("Calculating wallet values");const l=await db_1.models.wallet.findAll({where:{userId:t.id,type:{[sequelize_1.Op.in]:["FIAT","SPOT","ECO"]}},attributes:["type","currency","balance","inOrder"],raw:!0});let o=0;for(const e of l){const t=parseFloat(e.balance||"0")||0;if(t<=0)continue;let r=1;try{"USD"===e.currency?r=1:"FIAT"===e.type?r=await(0,utils_1.getFiatPriceInUSD)(e.currency)||1:"SPOT"===e.type||"FUTURES"===e.type?r=await(0,utils_1.getSpotPriceInUSD)(e.currency)||0:"ECO"===e.type&&(r=await(0,utils_1.getEcoPriceInUSD)(e.currency)||0)}catch(t){r="USD"===e.currency?1:0}o+=t*r}const u=parseFloat((null==e?void 0:e.completedVolume)||"0")||0,s=parseFloat((null==a?void 0:a.activeVolume)||"0")||0,i=o+s;null==r||r.success(`Portfolio data retrieved (total value: $${i.toFixed(2)})`);return{totalValue:i,completedVolume:u,activeVolume:s,walletValue:o,changePercentage:0,change24h:0,return30d:0,chartData:i>0?[{date:"Day 1",value:.95*i},{date:"Day 2",value:.97*i},{date:"Day 3",value:.96*i},{date:"Day 4",value:.98*i},{date:"Day 5",value:.99*i},{date:"Day 6",value:1.01*i},{date:"Today",value:i}]:[]}}catch(e){null==r||r.fail(e.message||"Failed to retrieve portfolio data");throw(0,error_1.createError)({statusCode:500,message:"Internal Server Error: "+e.message})}};