"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize"),query_1=require("@b/utils/query"),console_1=require("@b/utils/console");exports.metadata={summary:"Get current user's P2P offers",description:"Retrieves all offers created by the authenticated user, including ACTIVE and PAUSED offers",operationId:"getUserP2POffers",tags:["P2P","Offers"],logModule:"P2P",logTitle:"Get user's offers",requiresAuth:!0,responses:{200:{description:"User offers retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object"}}}}},401:query_1.unauthorizedResponse,500:query_1.serverErrorResponse}};exports.default=async e=>{const{user:r,ctx:s}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)(401,"Unauthorized");null==s||s.step("Fetching user's P2P offers");try{const e=(await db_1.models.p2pOffer.findAll({where:{userId:r.id,status:{[sequelize_1.Op.in]:["ACTIVE","PAUSED","PENDING_APPROVAL"]}},include:[{model:db_1.models.p2pPaymentMethod,as:"paymentMethods",attributes:["id","name","icon"],through:{attributes:[]}}],order:[["createdAt","DESC"]]})).map(e=>{const r=e.get({plain:!0});!r.priceCurrency&&r.priceConfig&&(r.priceCurrency=r.priceConfig.currency||"USD");return r});null==s||s.success(`Retrieved ${e.length} user offers`);return e}catch(e){console_1.logger.error("P2P_OFFER","Error fetching user P2P offers",e);null==s||s.fail(e.message||"Failed to fetch user offers");throw(0,error_1.createError)(500,"Failed to fetch user offers")}};