"use strict";function validateTradeAmount(e){if("number"!=typeof e||isNaN(e))return!1;return e>=1e-4&&e<=1e6}function validateTradeStatusTransition(e,t){const r=TRADE_STATUS_TRANSITIONS[e];return!!r&&r.includes(t)}function validateOfferStatusTransition(e,t){const r=OFFER_STATUS_TRANSITIONS[e];return!!r&&r.includes(t)}function sanitizeInput(e){return e&&"string"==typeof e?validator_1.default.escape(validator_1.default.stripLow(e.trim())):""}function validateMessage(e){if(!e||"string"!=typeof e)throw(0,error_1.createError)({statusCode:400,message:"Message must be a non-empty string"});const t=sanitizeInput(e);if(0===t.length)throw(0,error_1.createError)({statusCode:400,message:"Message cannot be empty"});if(t.length>1e3)throw(0,error_1.createError)({statusCode:400,message:"Message cannot exceed 1000 characters"});return t}function validatePaymentMethod(e){if(!e||"object"!=typeof e)throw(0,error_1.createError)({statusCode:400,message:"Invalid payment method data"});if(!e.name||"string"!=typeof e.name)throw(0,error_1.createError)({statusCode:400,message:"Payment method name is required"});const t=sanitizeInput(e.name);if(t.length<2||t.length>50)throw(0,error_1.createError)({statusCode:400,message:"Payment method name must be between 2-50 characters"});const r={name:t,icon:e.icon&&["credit-card","bank","wallet","cash","bitcoin","ethereum","paypal","venmo","zelle","wire-transfer"].includes(e.icon)?e.icon:"credit-card"};e.description&&(r.description=sanitizeInput(e.description).substring(0,200));e.instructions&&(r.instructions=sanitizeInput(e.instructions).substring(0,500));e.processingTime&&(r.processingTime=sanitizeInput(e.processingTime).substring(0,50));return r}function validateTradeTerms(e){if(!e||"string"!=typeof e)throw(0,error_1.createError)({statusCode:400,message:"Trade terms are required"});const t=sanitizeInput(e);if(t.length<10)throw(0,error_1.createError)({statusCode:400,message:"Trade terms must be at least 10 characters"});if(t.length>1e3)throw(0,error_1.createError)({statusCode:400,message:"Trade terms cannot exceed 1000 characters"});return t}function validateDisputeReason(e){if(!e||!["PAYMENT_NOT_RECEIVED","PAYMENT_INCORRECT_AMOUNT","CRYPTO_NOT_RELEASED","SELLER_UNRESPONSIVE","BUYER_UNRESPONSIVE","FRAUDULENT_ACTIVITY","TERMS_VIOLATION","OTHER"].includes(e))throw(0,error_1.createError)({statusCode:400,message:"Invalid dispute reason"});return e}function validateEvidenceFile(e){if(!e)return{isValid:!1,error:"No file provided"};if(e.size>5242880)return{isValid:!1,error:"File size exceeds 5MB limit"};if(!["image/jpeg","image/png","image/gif","application/pdf","text/plain"].includes(e.mimetype))return{isValid:!1,error:"Invalid file type. Allowed: JPEG, PNG, GIF, PDF, TXT"};const t=e.name.toLowerCase().substring(e.name.lastIndexOf("."));return[".jpg",".jpeg",".png",".gif",".pdf",".txt"].includes(t)?{isValid:!0}:{isValid:!1,error:"Invalid file extension"}}function validateLocationSettings(e){if(!e||"object"!=typeof e)throw(0,error_1.createError)({statusCode:400,message:"Location settings are required"});if(!e.country||"string"!=typeof e.country)throw(0,error_1.createError)({statusCode:400,message:"Country is required"});const t=e.country.toUpperCase();if(!validator_1.default.isISO31661Alpha2(t))throw(0,error_1.createError)({statusCode:400,message:"Invalid country code"});const r={country:t};e.region&&(r.region=sanitizeInput(e.region).substring(0,100));e.city&&(r.city=sanitizeInput(e.city).substring(0,100));e.restrictions&&Array.isArray(e.restrictions)&&(r.restrictions=e.restrictions.filter(e=>"string"==typeof e&&validator_1.default.isISO31661Alpha2(e)).slice(0,50));return r}function validateUserRequirements(e){if(!e||"object"!=typeof e)return null;const t={};"number"==typeof e.minCompletedTrades&&(t.minCompletedTrades=Math.max(0,Math.min(1e3,Math.floor(e.minCompletedTrades))));"number"==typeof e.minSuccessRate&&(t.minSuccessRate=Math.max(0,Math.min(100,e.minSuccessRate)));"number"==typeof e.minAccountAge&&(t.minAccountAge=Math.max(0,Math.min(365,Math.floor(e.minAccountAge))));"boolean"==typeof e.trustedOnly&&(t.trustedOnly=e.trustedOnly);return Object.keys(t).length>0?t:null}function validatePriceConfig(e,t){if(!e||"object"!=typeof e)throw(0,error_1.createError)({statusCode:400,message:"Price configuration is required"});if(!["FIXED","MARGIN"].includes(e.model))throw(0,error_1.createError)({statusCode:400,message:"Price model must be FIXED or MARGIN"});if("number"!=typeof e.value||e.value<=0)throw(0,error_1.createError)({statusCode:400,message:"Price value must be a positive number"});let r;if("FIXED"===e.model)r=e.value;else{if(!t||t<=0)throw(0,error_1.createError)({statusCode:400,message:"Market price is required for margin pricing"});if(e.value<-10||e.value>10)throw(0,error_1.createError)({statusCode:400,message:"Margin must be between -10% and +10%"});r=t*(1+e.value/100)}return{model:e.model,value:e.value,marketPrice:"MARGIN"===e.model?t:void 0,finalPrice:parseFloat(r.toFixed(8))}}var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.validateTradeAmount=validateTradeAmount;exports.validateTradeStatusTransition=validateTradeStatusTransition;exports.validateOfferStatusTransition=validateOfferStatusTransition;exports.sanitizeInput=sanitizeInput;exports.validateMessage=validateMessage;exports.validatePaymentMethod=validatePaymentMethod;exports.validateTradeTerms=validateTradeTerms;exports.validateDisputeReason=validateDisputeReason;exports.validateEvidenceFile=validateEvidenceFile;exports.validateLocationSettings=validateLocationSettings;exports.validateUserRequirements=validateUserRequirements;exports.validatePriceConfig=validatePriceConfig;const validator_1=__importDefault(require("validator")),error_1=require("@b/utils/error"),TRADE_STATUS_TRANSITIONS={PENDING:["PAYMENT_SENT","CANCELLED","EXPIRED"],PAYMENT_SENT:["COMPLETED","DISPUTED","CANCELLED"],COMPLETED:["DISPUTED"],DISPUTED:["COMPLETED","CANCELLED"],CANCELLED:[],EXPIRED:[]},OFFER_STATUS_TRANSITIONS={DRAFT:["PENDING_APPROVAL","CANCELLED"],PENDING_APPROVAL:["ACTIVE","REJECTED"],ACTIVE:["PAUSED","COMPLETED","CANCELLED"],PAUSED:["ACTIVE","CANCELLED"],COMPLETED:[],CANCELLED:[],REJECTED:[],EXPIRED:[]};