"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize");exports.metadata={summary:"Calculate Potential Staking Rewards",description:"Calculates potential rewards for a given amount and duration based on available staking pools.",operationId:"calculateStakingRewards",tags:["Staking","Rewards","Calculator"],requiresAuth:!0,logModule:"STAKING",logTitle:"Calculate rewards",parameters:[],requestBody:{required:!0,content:{"application/json":{schema:{type:"object",required:["amount","duration"],properties:{amount:{type:"number",description:"Amount to stake"},duration:{type:"number",description:"Duration in days"}}}}}},responses:{200:{description:"Rewards calculated successfully",content:{"application/json":{schema:{type:"object",properties:{calculations:{type:"array",items:{type:"object",properties:{poolId:{type:"string"},poolName:{type:"string"},tokenSymbol:{type:"string"},apr:{type:"number"},potentialReward:{type:"number"},totalReturn:{type:"number"}}}}}}}}},400:{description:"Bad Request"},401:{description:"Unauthorized"},500:{description:"Internal Server Error"}}};exports.default=async e=>{const{user:t,body:r,ctx:a}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const{amount:o,duration:n}=r;null==a||a.step("Validating calculation parameters");if(!o||o<=0)throw(0,error_1.createError)({statusCode:400,message:"Invalid amount"});if(!n||n<=0)throw(0,error_1.createError)({statusCode:400,message:"Invalid duration"});null==a||a.step("Finding eligible staking pools");const s={status:"ACTIVE",lockPeriod:{[sequelize_1.Op.lte]:n}},i=await db_1.models.stakingPool.findAll({where:s,order:[["apr","DESC"]]});null==a||a.step("Calculating potential rewards for each pool");const l=i.map(e=>{const{id:t,name:r,apr:a,symbol:s,icon:i,token:l}=e,u=o*(a/100)/365*n;return{poolId:t,poolName:r,tokenSymbol:s,tokenName:l,tokenIcon:i,apr:a,potentialReward:u,totalReturn:o+u}});null==a||a.success(`Calculated rewards for ${i.length} pools`);return{calculations:l}};