"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize"),wallet_1=require("@b/services/wallet"),affiliate_1=require("@b/utils/affiliate");exports.metadata={summary:"Stake Tokens",description:"Creates a new staking position for the authenticated user by staking tokens into a specified pool.",operationId:"stakeTokens",tags:["Staking","Positions"],requiresAuth:!0,logModule:"STAKING",logTitle:"Create staking position",rateLimit:{windowMs:6e4,max:5},requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{poolId:{type:"string",description:"The ID of the staking pool"},amount:{type:"number",description:"The amount of tokens to stake"}},required:["poolId","amount"]}}}},responses:{200:{description:"Staking position created successfully",content:{"application/json":{schema:{type:"object",properties:{id:{type:"string",description:"Staking position ID"},userId:{type:"string",description:"User ID"},poolId:{type:"string",description:"Pool ID"},amount:{type:"number",description:"Staked amount"},startDate:{type:"string",format:"date-time",description:"Staking start date"},endDate:{type:"string",format:"date-time",description:"Staking end date"},status:{type:"string",description:"Status of the staking position"},withdrawalRequested:{type:"boolean",description:"Withdrawal requested flag"},withdrawalRequestDate:{type:"string",format:"date-time",nullable:!0,description:"Date when withdrawal was requested"},adminNotes:{type:"string",nullable:!0,description:"Admin notes"},completedAt:{type:"string",format:"date-time",nullable:!0,description:"Completion timestamp"},createdAt:{type:"string",format:"date-time",description:"Creation timestamp"},updatedAt:{type:"string",format:"date-time",description:"Last update timestamp"}}}}}},400:{description:"Invalid request parameters or business logic validation failed"},401:{description:"Unauthorized"},404:{description:"Staking pool not found"},500:{description:"Internal Server Error"}}};exports.default=async e=>{const{user:t,body:a,ctx:o}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const{poolId:r,amount:i}=a;null==o||o.step("Validating stake parameters");if(await db_1.models.stakingPosition.count({where:{userId:t.id,createdAt:{[sequelize_1.Op.gte]:new Date(Date.now()-6e4)}}})>=5)throw(0,error_1.createError)({statusCode:429,message:"Too many staking requests. Please wait before trying again."});if(!r||"string"!=typeof r)throw(0,error_1.createError)({statusCode:400,message:"Valid poolId is required"});if("number"!=typeof i||isNaN(i)||!isFinite(i))throw(0,error_1.createError)({statusCode:400,message:"Valid numeric amount is required"});if(i<=0)throw(0,error_1.createError)({statusCode:400,message:"Amount must be greater than zero"});if((i.toString().split(".")[1]||"").length>8)throw(0,error_1.createError)({statusCode:400,message:"Amount can have maximum 8 decimal places"});null==o||o.step("Retrieving staking pool details");const s=await db_1.models.stakingPool.findByPk(r);if(!s)throw(0,error_1.createError)({statusCode:404,message:"Staking pool not found"});if("ACTIVE"!==s.status)throw(0,error_1.createError)({statusCode:400,message:"Staking pool is not active"});null==o||o.step("Validating stake amount against pool limits");if(i<s.minStake)throw(0,error_1.createError)({statusCode:400,message:`Amount must be at least ${s.minStake}`});if(s.maxStake&&i>s.maxStake)throw(0,error_1.createError)({statusCode:400,message:`Amount must not exceed ${s.maxStake}`});if(i>s.availableToStake)throw(0,error_1.createError)({statusCode:400,message:"Insufficient available amount to stake in this pool"});null==o||o.step("Checking user wallet balance");const n=await db_1.models.wallet.findOne({where:{userId:t.id,currency:s.symbol,type:s.walletType||"SPOT"}});if(!n)throw(0,error_1.createError)({statusCode:400,message:`You don't have a ${s.symbol} wallet. Please create one first.`});if(n.balance<i)throw(0,error_1.createError)({statusCode:400,message:`Insufficient balance. You have ${n.balance} ${s.symbol} but need ${i} ${s.symbol}`});null==o||o.step("Calculating staking period");const l=new Date,d=new Date(l.getTime()+24*s.lockPeriod*60*60*1e3);null==o||o.step("Creating staking position");const u=await db_1.sequelize.transaction();try{const e=await db_1.models.stakingPosition.create({userId:t.id,poolId:r,amount:i,startDate:l,endDate:d,status:"ACTIVE",withdrawalRequested:!1,withdrawalRequestDate:null,adminNotes:null,completedAt:null},{transaction:u});null==o||o.step("Deducting stake amount from wallet via wallet service");const a=s.walletType||"SPOT";await wallet_1.walletService.debit({idempotencyKey:`staking_create_${e.id}`,userId:t.id,walletId:n.id,walletType:a,currency:s.symbol,amount:i,operationType:"STAKING",description:`Staked ${i} ${s.symbol} in pool ${s.name}`,metadata:{positionId:e.id,poolId:s.id,poolName:s.name,lockPeriod:s.lockPeriod},transaction:u});null==o||o.step("Updating pool availability");s.availableToStake=s.availableToStake-i;await s.save({transaction:u});await u.commit();try{await(0,affiliate_1.processRewards)(t.id,i,"STAKING",s.symbol)}catch(e){console.error("Failed to process affiliate rewards:",e)}null==o||o.success(`Staked ${i} ${s.symbol} in pool ${s.name} for ${s.lockPeriod} days`);return e}catch(e){await u.rollback();null==o||o.fail(e.message||"Failed to stake tokens");throw(0,error_1.createError)({statusCode:500,message:e.message||"Failed to stake tokens"})}};