"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.apiKeyUpdateSchema=exports.apiKeyStoreSchema=exports.apiKeySchema=void 0;const schema_1=require("@b/utils/schema"),id={...(0,schema_1.baseStringSchema)("ID of the API key"),example:"123e4567-e89b-12d3-a456-426614174000"},userId={...(0,schema_1.baseStringSchema)("User ID associated with the API key"),example:"123e4567-e89b-12d3-a456-426614174001"},key={...(0,schema_1.baseStringSchema)("The API key string"),example:"a1b2c3d4e5f6g7h8i9j0"},createdAt={...(0,schema_1.baseDateTimeSchema)("Creation date of the API key"),example:"2025-02-20T10:00:00Z"},updatedAt={...(0,schema_1.baseDateTimeSchema)("Last update date of the API key",!0),example:"2025-02-20T10:05:00Z"},deletedAt={...(0,schema_1.baseDateTimeSchema)("Deletion date of the API key",!0),example:null},name={...(0,schema_1.baseStringSchema)("Name of the API key"),example:"A"},type={type:"string",enum:["plugin","user"],description:"Type of the API key (e.g., plugin, user)",example:"plugin"},permissions={type:"array",items:{type:"object",properties:{id:{type:"string",example:"trade"},name:{type:"string",example:"Trade"}},required:["id","name"]},description:"Permissions associated with the API key",example:[{id:"trade",name:"Trade"}]},ipWhitelist={type:"array",items:{type:"string",example:"127.0.0.1"},description:"IP addresses whitelisted for the API key",example:[]},ipRestriction={type:"boolean",description:"Whether IP restriction is enabled for the API key",example:!1};exports.apiKeySchema={type:"object",properties:{id:id,userId:userId,name:name,type:type,key:key,permissions:permissions,ipWhitelist:ipWhitelist,ipRestriction:ipRestriction,createdAt:createdAt,updatedAt:updatedAt,deletedAt:deletedAt},example:{id:"123e4567-e89b-12d3-a456-426614174000",userId:"123e4567-e89b-12d3-a456-426614174001",name:"A",type:"plugin",key:"a1b2c3d4e5f6g7h8i9j0",permissions:[{id:"trade",name:"Trade"}],ipWhitelist:[],ipRestriction:!1,createdAt:"2025-02-20T10:00:00Z",updatedAt:"2025-02-20T10:05:00Z",deletedAt:null}};exports.apiKeyStoreSchema={type:"object",properties:{userId:userId,name:name,type:type,permissions:permissions,ipWhitelist:ipWhitelist,ipRestriction:ipRestriction},required:["userId","name","type"],example:{userId:"123e4567-e89b-12d3-a456-426614174001",name:"A",type:"plugin",permissions:[{id:"trade",name:"Trade"}],ipWhitelist:[],ipRestriction:!1}};exports.apiKeyUpdateSchema={type:"object",properties:{name:name,type:type,permissions:permissions,ipWhitelist:ipWhitelist,ipRestriction:ipRestriction},required:["type"],example:{name:"A",type:"plugin",permissions:[{id:"trade",name:"Trade"}],ipWhitelist:[],ipRestriction:!1}};