"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize"),console_1=require("@b/utils/console");exports.metadata={summary:"Get Unified Blog Dashboard Data",description:"Retrieves aggregated data for the blog admin dashboard including post counts (published/draft), recent posts, author counts (approved/pending) with recent pending applications, total categories, total tags, and overall blog stats, plus top categories and tags.",operationId:"getBlogDashboardData",tags:["Blog","Admin","Dashboard"],requiresAuth:!0,responses:{200:{description:"Dashboard data retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{posts:{type:"object",properties:{publishedCount:{type:"number"},draftCount:{type:"number"},recentPosts:{type:"array",items:{type:"object"}}}},authors:{type:"object",properties:{approvedCount:{type:"number"},pendingCount:{type:"number"},recentPendingAuthors:{type:"array",items:{type:"object"}}}},categories:{type:"object",properties:{count:{type:"number"},list:{type:"array",items:{type:"object"}}}},tags:{type:"object",properties:{count:{type:"number"},list:{type:"array",items:{type:"object"}}}},stats:{type:"object",properties:{totalPosts:{type:"number"},totalComments:{type:"number"},totalAuthors:{type:"number"},totalReaders:{type:"number"}}}}}}}},401:{description:"Unauthorized"},500:{description:"Internal Server Error"}},permission:"access.blog",logModule:"ADMIN_BLOG",logTitle:"Get blog dashboard stats"};exports.default=async e=>{const{user:t,ctx:s}=e;null==s||s.step("Validating user authorization");if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});try{null==s||s.step("Fetching post statistics");const e=await db_1.models.post.count({where:{status:"PUBLISHED"}}),t=await db_1.models.post.count({where:{status:"DRAFT"}}),o=await db_1.models.post.findAll({order:[["createdAt","DESC"]],limit:5,include:[{model:db_1.models.author,as:"author",include:[{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","email","avatar"]}]},{model:db_1.models.category,as:"category",attributes:["id","name","slug"]}]});null==s||s.step("Fetching author statistics");const a=await db_1.models.author.count({where:{status:"APPROVED"}}),r=await db_1.models.author.count({where:{status:"PENDING"}}),i=await db_1.models.author.findAll({where:{status:"PENDING"},order:[["createdAt","DESC"]],limit:3,include:[{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","email","avatar"]}]});null==s||s.step("Fetching category statistics");const l=await db_1.models.category.count(),u=await db_1.models.category.findAll({subQuery:!1,attributes:["id","name","slug","description",[sequelize_1.Sequelize.fn("COUNT",sequelize_1.Sequelize.col("posts.id")),"postCount"]],include:[{model:db_1.models.post,as:"posts",attributes:[],required:!1}],group:["category.id"],order:[[sequelize_1.Sequelize.fn("COUNT",sequelize_1.Sequelize.col("posts.id")),"DESC"]],limit:5});null==s||s.step("Fetching tag statistics");const d=await db_1.models.tag.count(),n=await db_1.models.tag.findAll({subQuery:!1,attributes:["id","name","slug",[sequelize_1.Sequelize.fn("COUNT",sequelize_1.Sequelize.col("posts.id")),"postCount"]],include:[{model:db_1.models.post,as:"posts",attributes:[],through:{attributes:[]},required:!1}],group:["tag.id"],order:[[sequelize_1.Sequelize.fn("COUNT",sequelize_1.Sequelize.col("posts.id")),"DESC"]],limit:10});null==s||s.step("Calculating overall statistics");const c=await db_1.models.comment.count(),p={totalPosts:e,totalComments:c,totalAuthors:a,totalReaders:0};null==s||s.success("Dashboard statistics retrieved successfully");return{posts:{publishedCount:e,draftCount:t,recentPosts:o.map(e=>e.toJSON())},authors:{approvedCount:a,pendingCount:r,recentPendingAuthors:i.map(e=>e.toJSON())},categories:{count:l,list:u.map(e=>e.toJSON())},tags:{count:d,list:n.map(e=>e.toJSON())},stats:p}}catch(e){null==s||s.fail("Failed to fetch dashboard data");console_1.logger.error("BLOG","Error fetching dashboard data",e);throw(0,error_1.createError)({statusCode:500,message:"Failed to fetch dashboard data"})}};