"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error");exports.metadata={summary:"Create a New KYC Level",description:"Creates a new KYC level with the provided details.",operationId:"createKycLevel",tags:["KYC","Levels"],logModule:"ADMIN_CRM",logTitle:"Create KYC level",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{name:{type:"string",description:"Name of the level"},description:{type:"string",description:"Level description"},level:{type:"number",description:"Numeric level order"},fields:{type:"array",description:"Array of fields",items:{type:"object"}},features:{type:"array",description:"Array of features",items:{type:"string"}},serviceId:{type:"string",description:"Verification service ID"},status:{type:"string",enum:["ACTIVE","DRAFT","INACTIVE"],description:"Level status"}},required:["name","description","level","status"]}}}},responses:{200:{description:"KYC level created successfully.",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string"},level:{type:"object"}}}}}},400:{description:"Missing required fields."},500:{description:"Internal Server Error."}},permission:"create.kyc.level",requiresAuth:!0};exports.default=async e=>{const{body:t,ctx:r}=e,{name:s,description:i,level:l,fields:o,features:a,serviceId:c,status:n}=t;if(!s||void 0===l||!n)throw(0,error_1.createError)({statusCode:400,message:"Missing required fields"});let d=null;if(c&&""!==c.trim()){null==r||r.step("Validating verification service");if(!await db_1.models.kycVerificationService.findByPk(c))throw(0,error_1.createError)({statusCode:400,message:`Invalid serviceId: ${c}. Service does not exist.`});d=c}null==r||r.step(`Creating KYC level: ${s}`);const p=await db_1.models.kycLevel.create({name:s,description:i,level:l,fields:o||[],features:a||[],serviceId:d,status:n});null==r||r.success("KYC level created successfully");return{message:"KYC level created successfully.",item:p}};