"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const error_1=require("@b/utils/error"),db_1=require("@b/db"),sync_1=require("csv-stringify/sync"),demoMask_1=require("@b/utils/demoMask");exports.metadata={summary:"Export all users as a CSV file",operationId:"exportUsersToCSV",tags:["Admin","CRM","User"],parameters:[{name:"includePasswords",in:"query",description:"Include encrypted passwords in export",required:!1,schema:{type:"boolean",default:!1}},{name:"status",in:"query",description:"Filter by user status",required:!1,schema:{type:"string",enum:["ACTIVE","INACTIVE","BANNED","SUSPENDED"]}}],responses:{200:{description:"CSV file with user data",content:{"text/csv":{schema:{type:"string"}}}},401:{description:"Unauthorized access"}},requiresAuth:!0,permission:"export.user"};exports.default=async e=>{const{user:t,query:i}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized access"});const r="true"===(null==i?void 0:i.includePasswords),s=null==i?void 0:i.status,o={};s&&(o.status=s);const a=(await db_1.models.user.findAll({where:o,include:[{model:db_1.models.role,as:"role"}],order:[["createdAt","DESC"]]})).map(e=>{var t,i,s,o,a,l,d,n,u,c;const p={email:e.email||"",firstName:e.firstName||"",lastName:e.lastName||"",password:r?e.password:"",phone:e.phone||"",status:e.status||"ACTIVE",emailVerified:e.emailVerified?"true":"false",twoFactor:e.twoFactor?"true":"false",roleId:e.roleId||"",avatar:e.avatar||""};if(e.profile){const r="string"==typeof e.profile?JSON.parse(e.profile):e.profile;p.bio=r.bio||"";p.address=(null===(t=r.location)||void 0===t?void 0:t.address)||"";p.city=(null===(i=r.location)||void 0===i?void 0:i.city)||"";p.country=(null===(s=r.location)||void 0===s?void 0:s.country)||"";p.zip=(null===(o=r.location)||void 0===o?void 0:o.zip)||"";p.facebook=(null===(a=r.social)||void 0===a?void 0:a.facebook)||"";p.twitter=(null===(l=r.social)||void 0===l?void 0:l.twitter)||"";p.instagram=(null===(d=r.social)||void 0===d?void 0:d.instagram)||"";p.github=(null===(n=r.social)||void 0===n?void 0:n.github)||"";p.dribbble=(null===(u=r.social)||void 0===u?void 0:u.dribbble)||"";p.gitlab=(null===(c=r.social)||void 0===c?void 0:c.gitlab)||""}else{p.bio="";p.address="";p.city="";p.country="";p.zip="";p.facebook="";p.twitter="";p.instagram="";p.github="";p.dribbble="";p.gitlab=""}return p}),l=(0,demoMask_1.applyDemoMask)(a,["email","phone"]);return{data:(0,sync_1.stringify)(l,{header:!0,columns:["email","firstName","lastName","password","phone","status","emailVerified","twoFactor","roleId","avatar","bio","address","city","country","zip","facebook","twitter","instagram","github","dribbble","gitlab"]}),headers:{"Content-Type":"text/csv","Content-Disposition":`attachment; filename="users_export_${(new Date).toISOString().split("T")[0]}.csv"`}}};