"use strict";async function getUserCountsPerDay(e){var t,a,s;null===(t=null==e?void 0:e.step)||void 0===t||t.call(e,"Fetching user counts for the last 30 days");const r=new Date;r.setDate(r.getDate()-30);const i=await db_1.models.user.findAll({where:{createdAt:{[sequelize_1.Op.gte]:r}},attributes:["createdAt","status","emailVerified"]});null===(a=null==e?void 0:e.step)||void 0===a||a.call(e,"Processing user count statistics");const o={registrations:{},activeUsers:{},bannedUsers:{},verifiedEmails:{}};i.forEach(e=>{if(!e.createdAt)return;const t=e.createdAt.toISOString().split("T")[0];o.registrations[t]=(o.registrations[t]||0)+1;"ACTIVE"===e.status&&(o.activeUsers[t]=(o.activeUsers[t]||0)+1);"BANNED"===e.status&&(o.bannedUsers[t]=(o.bannedUsers[t]||0)+1);e.emailVerified&&(o.verifiedEmails[t]=(o.verifiedEmails[t]||0)+1)});null===(s=null==e?void 0:e.success)||void 0===s||s.call(e,"User counts calculated successfully");return{registrations:(0,utils_1.convertAndSortCounts)(o.registrations),activeUsers:(0,utils_1.convertAndSortCounts)(o.activeUsers),bannedUsers:(0,utils_1.convertAndSortCounts)(o.bannedUsers),verifiedEmails:(0,utils_1.convertAndSortCounts)(o.verifiedEmails)}}Object.defineProperty(exports,"__esModule",{value:!0});exports.userStoreSchema=exports.userUpdateSchema=exports.userSchema=void 0;exports.getUserCountsPerDay=getUserCountsPerDay;const utils_1=require("@b/utils"),db_1=require("@b/db"),sequelize_1=require("sequelize"),schema_1=require("@b/utils/schema"),id=(0,schema_1.baseStringSchema)("ID of the user"),email=(0,schema_1.baseStringSchema)("Email of the user",100,0,!1,"^[^@]+@[^@]+\\.[^@]+$","example@site.com"),avatar=(0,schema_1.baseStringSchema)("Avatar of the user",255,0,!0),firstName=(0,schema_1.baseStringSchema)("First name of the user",50),lastName=(0,schema_1.baseStringSchema)("Last name of the user",50),emailVerified=(0,schema_1.baseBooleanSchema)("Email verification status"),phone=(0,schema_1.baseStringSchema)("User's phone number",10,10,!0,"^[0-9]{10}$","1234567890"),status=(0,schema_1.baseEnumSchema)("Status of the user",["ACTIVE","INACTIVE","BANNED","SUSPENDED"]),roleId=(0,schema_1.baseStringSchema)("Role ID associated with the user"),twoFactor=(0,schema_1.baseBooleanSchema)("Whether two-factor authentication is enabled"),profile={type:"object",nullable:!0,properties:{bio:(0,schema_1.baseStringSchema)("Bio",500),location:{type:"object",properties:{address:(0,schema_1.baseStringSchema)("Detailed address of the user"),city:(0,schema_1.baseStringSchema)("City"),country:(0,schema_1.baseStringSchema)("Country"),zip:(0,schema_1.baseStringSchema)("Zip code",10,5,!1)}},social:{type:"object",properties:{facebook:(0,schema_1.baseStringSchema)("Facebook URL",255,0,!0,"^https?:\\/\\/[\\w.-]+(?:\\.[\\w\\.-]+)+[\\w\\-._~:/?#[\\]@!$&'()*+,;=]+$","http://facebook.com/yourusername"),twitter:(0,schema_1.baseStringSchema)("Twitter URL",255,0,!0,"^https?:\\/\\/[\\w.-]+(?:\\.[\\w\\.-]+)+[\\w\\-._~:/?#[\\]@!$&'()*+,;=]+$","http://twitter.com/yourusername"),dribbble:(0,schema_1.baseStringSchema)("Dribbble URL",255,0,!0,"^https?:\\/\\/[\\w.-]+(?:\\.[\\w\\.-]+)+[\\w\\-._~:/?#[\\]@!$&'()*+,;=]+$","http://dribbble.com/yourusername"),instagram:(0,schema_1.baseStringSchema)("Instagram URL",255,0,!0,"^https?:\\/\\/[\\w.-]+(?:\\.[\\w\\.-]+)+[\\w\\-._~:/?#[\\]@!$&'()*+,;=]+$","http://instagram.com/yourusername"),github:(0,schema_1.baseStringSchema)("Github URL",255,0,!0,"^https?:\\/\\/[\\w.-]+(?:\\.[\\w\\.-]+)+[\\w\\-._~:/?#[\\]@!$&'()*+,;=]+$","http://github.com/yourusername"),gitlab:(0,schema_1.baseStringSchema)("Gitlab URL",255,0,!0,"^https?:\\/\\/[\\w.-]+(?:\\.[\\w\\.-]+)+[\\w\\-._~:/?#[\\]@!$&'()*+,;=]+$","http://gitlab.com/yourusername")}}}},lastLogin=(0,schema_1.baseDateTimeSchema)("Last login date"),lastFailedLogin=(0,schema_1.baseDateTimeSchema)("Last failed login date"),failedLoginAttempts=(0,schema_1.baseIntegerSchema)("Number of failed login attempts"),walletAddress=(0,schema_1.baseStringSchema)("Wallet address of the user"),walletProvider=(0,schema_1.baseStringSchema)("Wallet provider of the user");exports.userSchema={id:id,email:email,avatar:avatar,firstName:firstName,lastName:lastName,emailVerified:emailVerified,phone:phone,status:status,roleId:roleId,twoFactor:twoFactor,profile:profile,lastLogin:lastLogin,lastFailedLogin:lastFailedLogin,failedLoginAttempts:failedLoginAttempts,walletAddress:walletAddress,walletProvider:walletProvider};exports.userUpdateSchema={type:"object",properties:{avatar:avatar,firstName:firstName,lastName:lastName,email:email,phone:phone,status:status,emailVerified:emailVerified,twoFactor:twoFactor,profile:profile,roleId:roleId},required:["email","firstName","lastName","roleId"]};exports.userStoreSchema={description:"User created or updated successfully",content:{"application/json":{schema:{type:"object",properties:exports.userSchema}}}};