"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),query_1=require("@b/utils/query"),console_1=require("@b/utils/console"),error_1=require("@b/utils/error");exports.metadata={summary:"Import Binary Markets from Exchange Markets",operationId:"importBinaryMarkets",tags:["Admin","Binary","Markets"],description:"Imports spot markets from exchange markets and creates binary markets for trading.",requiresAuth:!0,responses:{200:{description:"Binary markets imported successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string"},imported:{type:"number"},skipped:{type:"number"}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Exchange Markets"),500:query_1.serverErrorResponse},permission:"create.binary.market"};exports.default=async()=>{try{const e=await db_1.models.exchangeMarket.findAll({where:{status:!0},attributes:["currency","pair"]});if(0===e.length)throw(0,error_1.createError)({statusCode:404,message:"No active exchange markets found to import"});const r=await db_1.models.binaryMarket.findAll({attributes:["currency","pair"]}),t=new Set(r.map(e=>`${e.currency}/${e.pair}`)),a=e.filter(e=>!t.has(`${e.currency}/${e.pair}`));let s=0;const o=e.length-a.length;await db_1.sequelize.transaction(async e=>{for(const r of a){await db_1.models.binaryMarket.create({currency:r.currency,pair:r.pair,isTrending:!1,isHot:!1,status:!1},{transaction:e});s++}});return{message:`Successfully imported ${s} binary markets from exchange markets`,imported:s,skipped:o}}catch(e){console_1.logger.error("BINARY","Error importing binary markets",e);throw e}};