"use strict";function calculateOptimalPayout(e){if(e<=.5)return 100;if(e>=1)return 0;const t=100/e-100;return Math.round(10*t)/10}function calculateBreakEvenRate(e){return 100/(100+e)}function calculatePlatformEdge(e){return 100*(calculateBreakEvenRate(e)-.5)}function getDurationCategory(e){return e<=1?"ULTRA_SHORT":e<=5?"SHORT":e<=30?"MEDIUM":"LONG"}function interpolateWinProbability(e){const t=Object.keys(BARRIER_WIN_PROBABILITY).map(Number).sort((e,t)=>e-t);let r=t[0],a=t[t.length-1];for(let o=0;o<t.length-1;o++)if(e>=t[o]&&e<=t[o+1]){r=t[o];a=t[o+1];break}if(e<=r)return BARRIER_WIN_PROBABILITY[r];if(e>=a)return BARRIER_WIN_PROBABILITY[a];const o=BARRIER_WIN_PROBABILITY[r];return o+(BARRIER_WIN_PROBABILITY[a]-o)*((e-r)/(a-r))}function optimizeRiseFallPayout(e){const t=getDurationCategory(e),r=calculateOptimalPayout((50+PLATFORM_EDGE_BY_DURATION[t])/100);return Math.round(r*ORDER_TYPE_RISK_MULTIPLIER.RISE_FALL)}function optimizeBarrierPayout(e,t,r,a){const o=interpolateWinProbability(e),i=getDurationCategory(t),n=PLATFORM_EDGE_BY_DURATION[i];let l=calculateOptimalPayout(Math.max(.51,o+n/100));if("TOUCH_NO_TOUCH"===r){l*="TOUCH"===a?ORDER_TYPE_RISK_MULTIPLIER.TOUCH:ORDER_TYPE_RISK_MULTIPLIER.NO_TOUCH}else"HIGHER_LOWER"===r?l*=ORDER_TYPE_RISK_MULTIPLIER.HIGHER_LOWER:"TURBO"===r&&(l*=ORDER_TYPE_RISK_MULTIPLIER.TURBO);return Math.max(30,Math.min(200,Math.round(l)))}function generateOptimizedBarrierLevels(e,t=5){const r=[],a={.03:"Tight",.05:"Close",.08:"Near",.1:"Near",.2:"Medium",.3:"Standard",.5:"Far",1:"Very Far"};("TURBO"===e?[.03,.05,.08,.1]:"TOUCH_NO_TOUCH"===e?[.1,.2,.3,.5]:[.1,.2,.3,.5,1]).forEach((o,i)=>{const n=optimizeBarrierPayout(o,t,e);r.push({id:`${e.toLowerCase()}_${i}`,label:`${a[o]||"Level"} (${o}%)`,distancePercent:o,profitPercent:n,enabled:!0})});return r}function generateOptimizedDuration(e){const t=getDurationCategory(e),r=(calculateOptimalPayout((50+PLATFORM_EDGE_BY_DURATION[t])/100),{RISE_FALL:0});r.HIGHER_LOWER=Math.round(100*(ORDER_TYPE_RISK_MULTIPLIER.HIGHER_LOWER-1));r.TOUCH_NO_TOUCH=0;r.CALL_PUT=Math.round(100*(ORDER_TYPE_RISK_MULTIPLIER.CALL_PUT-1));e<=5&&(r.TURBO=Math.round(100*(ORDER_TYPE_RISK_MULTIPLIER.TURBO-1)));return{id:`duration_${e}m`,minutes:e,enabled:!0,orderTypeOverrides:{RISE_FALL:{enabled:!0,profitAdjustment:r.RISE_FALL},HIGHER_LOWER:{enabled:!0,profitAdjustment:r.HIGHER_LOWER},TOUCH_NO_TOUCH:{enabled:!0,profitAdjustment:r.TOUCH_NO_TOUCH},CALL_PUT:{enabled:!0,profitAdjustment:r.CALL_PUT},TURBO:{enabled:e<=5,profitAdjustment:r.TURBO||0}}}}function generateOptimizedSettings(){const e=[1,2,3,5,10,15,30,60].map(generateOptimizedDuration),t=optimizeRiseFallPayout(5);return{orderTypes:{RISE_FALL:{enabled:!0,profitPercentage:t,tradingModes:{demo:!0,live:!0}},HIGHER_LOWER:{enabled:!1,profitPercentage:Math.round(.95*t),barrierLevels:generateOptimizedBarrierLevels("HIGHER_LOWER",5),tradingModes:{demo:!0,live:!0}},TOUCH_NO_TOUCH:{enabled:!1,profitPercentage:Math.round(1.1*t),touchProfitMultiplier:1.15,noTouchProfitMultiplier:.85,barrierLevels:generateOptimizedBarrierLevels("TOUCH_NO_TOUCH",5),tradingModes:{demo:!0,live:!0}},CALL_PUT:{enabled:!1,profitPercentage:Math.round(.92*t),strikeLevels:[{id:"cp_atm",label:"At The Money (0.1%)",distancePercent:.1,profitPercent:65,enabled:!0},{id:"cp_near",label:"Near (0.2%)",distancePercent:.2,profitPercent:58,enabled:!0},{id:"cp_far",label:"Far (0.5%)",distancePercent:.5,profitPercent:48,enabled:!0}],tradingModes:{demo:!0,live:!0}},TURBO:{enabled:!1,profitPercentage:Math.round(.9*t),barrierLevels:generateOptimizedBarrierLevels("TURBO",1),payoutPerPointRange:{min:.1,max:10},maxDuration:5,allowTicksBased:!0,tradingModes:{demo:!0,live:!0}}},durations:e}}function calculateExpectedPlatformProfit(e){var t,r;const a={},o={};for(const o of e.durations.filter(e=>e.enabled)){const i=e.orderTypes.RISE_FALL.profitPercentage,n=i+i*((null===(r=null===(t=o.orderTypeOverrides)||void 0===t?void 0:t.RISE_FALL)||void 0===r?void 0:r.profitAdjustment)||0)/100;a[o.minutes]=calculatePlatformEdge(n)}for(const[t,r]of Object.entries(e.orderTypes))r.enabled&&(o[t]=calculatePlatformEdge(r.profitPercentage));const i=Object.values(o).filter(e=>!isNaN(e));return{overallEdge:i.length>0?i.reduce((e,t)=>e+t,0)/i.length:0,byDuration:a,byOrderType:o}}function analyzePayoutOptimization(e){const t=[],r=[],a=[],o=calculateExpectedPlatformProfit(e);o.overallEdge<5?r.push(`Low platform edge (${o.overallEdge.toFixed(1)}%). Consider lowering payouts.`):o.overallEdge>15?r.push(`High platform edge (${o.overallEdge.toFixed(1)}%). May discourage traders.`):t.push(`Healthy platform edge of ${o.overallEdge.toFixed(1)}%`);for(const[t,o]of Object.entries(e.orderTypes))if(o.enabled&&"barrierLevels"in o){const e=o.barrierLevels||[];for(const o of e)if(o.enabled&&o.distancePercent>1&&o.profitPercent>60){r.push(`${t}: Barrier "${o.label}" has abuse potential (${o.distancePercent}% distance with ${o.profitPercent}% profit)`);a.push(`Reduce profit for ${t} barrier "${o.label}" to below 50%`)}}for(const t of e.durations.filter(e=>e.enabled)){const e=getDurationCategory(t.minutes),r=PLATFORM_EDGE_BY_DURATION[e],i=o.byDuration[t.minutes]||0;i<r-2&&a.push(`${t.minutes}min: Consider lowering payout (current edge: ${i.toFixed(1)}%, recommended: ${r}%)`)}0===r.length&&t.push("Settings appear balanced for platform profitability");return{analysis:t,warnings:r,recommendations:a}}function getPayoutSummaryTable(){const e=[];e.push("| Duration | Category | Platform Edge | Optimal Payout | Break-Even |");e.push("|----------|----------|---------------|----------------|------------|");const t=[1,2,5,10,30,60];for(const r of t){const t=getDurationCategory(r),a=PLATFORM_EDGE_BY_DURATION[t],o=50+a,i=calculateOptimalPayout(o/100);e.push(`| ${r}min | ${t} | ${a}% | ${i}% | ${o}% |`)}return e.join("\n")}Object.defineProperty(exports,"__esModule",{value:!0});exports.calculateOptimalPayout=calculateOptimalPayout;exports.calculateBreakEvenRate=calculateBreakEvenRate;exports.calculatePlatformEdge=calculatePlatformEdge;exports.getDurationCategory=getDurationCategory;exports.optimizeRiseFallPayout=optimizeRiseFallPayout;exports.optimizeBarrierPayout=optimizeBarrierPayout;exports.generateOptimizedBarrierLevels=generateOptimizedBarrierLevels;exports.generateOptimizedDuration=generateOptimizedDuration;exports.generateOptimizedSettings=generateOptimizedSettings;exports.calculateExpectedPlatformProfit=calculateExpectedPlatformProfit;exports.analyzePayoutOptimization=analyzePayoutOptimization;exports.getPayoutSummaryTable=getPayoutSummaryTable;const PLATFORM_EDGE_BY_DURATION={ULTRA_SHORT:8,SHORT:7,MEDIUM:9,LONG:10},ORDER_TYPE_RISK_MULTIPLIER={RISE_FALL:1,HIGHER_LOWER:.95,TOUCH:1.15,NO_TOUCH:.85,CALL_PUT:.92,TURBO:.9},BARRIER_WIN_PROBABILITY={.03:.3,.05:.35,.1:.42,.15:.47,.2:.52,.3:.58,.5:.65,1:.75,2:.85,5:.95};