"use strict";function getIntervalMs(e){return{"1m":6e4,"3m":18e4,"5m":3e5,"15m":9e5,"30m":18e5,"1h":36e5,"2h":72e5,"4h":144e5,"6h":216e5,"8h":288e5,"12h":432e5,"1d":864e5,"3d":2592e5,"1w":6048e5}[e]||6e4}function compress(e){return zlib_1.default.gzipSync(JSON.stringify(e))}function decompress(e){return JSON.parse(zlib_1.default.gunzipSync(e).toString())}function getCacheFilePath(e,t){const[r,s]=e.split("/"),a=path_1.default.join(cacheDirPath,r,s);return path_1.default.join(a,`${t}.json.gz`)}function findGaps(e,t){const r=[];if(!Array.isArray(e)||e.length<2)return r;for(let s=1;s<e.length;s++){const a=e[s-1][0]+t,i=e[s][0];i>a+t&&r.push({start:e[s-1][0],end:i,missingCandles:Math.floor((i-a)/t)})}return r}var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const fs_1=__importDefault(require("fs")),path_1=__importDefault(require("path")),zlib_1=__importDefault(require("zlib")),redis_1=require("@b/utils/redis"),exchange_1=__importDefault(require("@b/utils/exchange")),query_1=require("@b/utils/query"),error_1=require("@b/utils/error"),redis=redis_1.RedisSingleton.getInstance(),cacheDirPath=path_1.default.resolve(process.cwd(),"data","chart");exports.metadata={summary:"Fix gaps in chart data for specified market and interval",operationId:"fixChartDataGaps",tags:["Admin","Exchange","Chart"],requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{symbol:{type:"string",description:"Market symbol (e.g., 'BTC/USDT')"},interval:{type:"string",description:"Interval to fix (e.g., '1h')"},rateLimit:{type:"number",description:"Delay in milliseconds between API requests",default:500},maxGaps:{type:"number",description:"Maximum number of gaps to fix in one request",default:10}},required:["symbol","interval"]}}}},responses:{200:{description:"Gap fix result",content:{"application/json":{schema:{type:"object",properties:{success:{type:"boolean"},gapsFound:{type:"number"},gapsFixed:{type:"number"},candlesAdded:{type:"number"},errors:{type:"array",items:{type:"string"}}}}}}},401:query_1.unauthorizedResponse,500:query_1.serverErrorResponse},requiresAuth:!0,permission:"manage.exchange.chart"};exports.default=async e=>{var t,r;const{body:s}=e,{symbol:a,interval:i,rateLimit:n=500,maxGaps:o=10}=s;if(!a||!i)throw(0,error_1.createError)({statusCode:400,message:"symbol and interval are required"});const c=getCacheFilePath(a,i),u=getIntervalMs(i),d=[];if(!fs_1.default.existsSync(c))throw(0,error_1.createError)({statusCode:404,message:`No cache file found for ${a}:${i}`});let l;try{l=decompress(fs_1.default.readFileSync(c))}catch(e){throw(0,error_1.createError)({statusCode:500,message:`Failed to read cache: ${e.message}`})}const p=findGaps(l,u);if(0===p.length)return{success:!0,gapsFound:0,gapsFixed:0,candlesAdded:0,errors:[],message:"No gaps found in chart data"};const f=p.slice(0,o);let h=0,m=0;try{const e=await exchange_1.default.startExchange();if(!e)throw(0,error_1.createError)({statusCode:500,message:"Exchange not available"});for(const s of f)try{const t=s.start+u,r=await e.fetchOHLCV(a,i,t,s.missingCandles+1);if(r&&r.length>0){const e=r.filter(e=>e[0]>s.start&&e[0]<s.end);if(e.length>0){l.push(...e);m+=e.length}h++}await new Promise(e=>setTimeout(e,n))}catch(e){d.push(`Gap at ${new Date(s.start).toISOString()}: ${e.message}`);((null===(t=e.message)||void 0===t?void 0:t.includes("rate"))||(null===(r=e.message)||void 0===r?void 0:r.includes("limit")))&&await new Promise(e=>setTimeout(e,5*n))}const s=new Map;for(const e of l)s.set(e[0],e);const o=Array.from(s.values()).sort((e,t)=>e[0]-t[0]),p=path_1.default.dirname(c);fs_1.default.existsSync(p)||fs_1.default.mkdirSync(p,{recursive:!0});const g=compress(o);fs_1.default.writeFileSync(c,g);const y=`ohlcv:${a}:${i}`;await redis.set(y,JSON.stringify(o),"EX",86400)}catch(e){d.push(`Exchange error: ${e.message}`)}const g={gapsFound:p.length,gapsFixed:h,candlesAdded:m,remainingGaps:p.length-h};d.length>0&&(g.errors=d);return g};