"use strict";var __importDefault=this&&this.__importDefault||function(r){return r&&r.__esModule?r:{default:r}};Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const error_1=require("@b/utils/error"),cron_1=__importDefault(require("@b/cron"));exports.metadata={summary:"Manually trigger a cron job",operationId:"triggerCronJob",tags:["Admin","Cron"],description:"Manually triggers execution of a specific cron job for testing purposes.",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{cronName:{type:"string",description:"The name of the cron job to trigger"}},required:["cronName"]}}}},responses:{200:{description:"Cron job triggered successfully",content:{"application/json":{schema:{type:"object",properties:{success:{type:"boolean",description:"Whether the job was triggered successfully"},message:{type:"string",description:"Success or error message"},cronName:{type:"string",description:"The name of the triggered cron job"}}}}}},400:{description:"Bad Request - Invalid cron job name or job is already running"},404:{description:"Cron job not found"},500:{description:"Internal server error during job execution"}},permission:"manage.cron",logModule:"ADMIN_SYS",logTitle:"Trigger cron job"};exports.default=async r=>{const{cronName:e}=r.body,{ctx:o}=r;if(!e||"string"!=typeof e)throw(0,error_1.createError)({statusCode:400,message:"cronName is required and must be a string"});try{null==o||o.step("Validating cron job request");const r=await cron_1.default.getInstance(),t=r.getCronJobs();null==o||o.step(`Checking if cron job '${e}' exists`);const s=t.find(r=>r.name===e);if(!s){null==o||o.fail(`Cron job '${e}' not found`);throw(0,error_1.createError)({statusCode:404,message:`Cron job '${e}' not found`})}if("running"===s.status){null==o||o.warn(`Cron job '${e}' is already running`);throw(0,error_1.createError)({statusCode:400,message:`Cron job '${e}' is already running`})}null==o||o.step(`Triggering cron job '${e}'`);if(await r.triggerJob(e)){null==o||o.success(`Cron job '${e}' triggered successfully`);return{success:!0,message:`Cron job '${e}' triggered successfully`,cronName:e}}null==o||o.fail(`Failed to trigger cron job '${e}'`);throw(0,error_1.createError)({statusCode:500,message:`Failed to trigger cron job '${e}'`})}catch(r){if(r.statusCode)throw r;null==o||o.fail(`Error triggering cron job: ${r.message}`);throw(0,error_1.createError)({statusCode:500,message:`Error triggering cron job: ${r.message}`})}};