"use strict";var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const promises_1=require("fs/promises"),error_1=require("@b/utils/error"),path_1=__importDefault(require("path")),date_fns_1=require("date-fns");exports.metadata={summary:"Lists database backups",description:"Returns a list of database backups with their details",operationId:"listDatabaseBackups",tags:["Admin","Database"],requiresAuth:!0,responses:{200:{description:"List of database backups",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:{filename:{type:"string",description:"Name of the backup file"},path:{type:"string",description:"Path to the backup file"},createdAt:{type:"string",format:"date-time",description:"Timestamp of when the backup was created"}}}}}}},500:{description:"Internal server error"}},permission:"access.database"};const backupDir=path_1.default.resolve(process.cwd(),"backup"),parseDateFromFilename=e=>{const t=e.split(".")[0];return(0,date_fns_1.parse)(t,"yyyy_MM_dd_HH_mm_ss",new Date)},listDatabaseBackups=async()=>{try{await(0,promises_1.mkdir)(backupDir,{recursive:!0});const e=await(0,promises_1.readdir)(backupDir,{withFileTypes:!0});return e.filter(e=>e.isFile()&&e.name.endsWith(".sql")).map(e=>{const t=parseDateFromFilename(e.name);return{filename:e.name,path:`/backup/${e.name}`,createdAt:(0,date_fns_1.formatDate)(t,"yyyy-MM-dd HH:mm:ss")}})}catch(e){throw(0,error_1.createError)({statusCode:500,message:e.message})}};exports.default=async()=>{try{return await listDatabaseBackups()}catch(e){throw(0,error_1.createError)({statusCode:500,message:e.message})}};