"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const utils_1=require("@b/api/admin/system/utils"),security_1=require("@b/utils/security"),Middleware_1=require("@b/handler/Middleware"),error_1=require("@b/utils/error");exports.metadata={summary:"Activates the license from an Envato license file in the /lic folder",operationId:"activateLicenseFromFile",tags:["Admin","System"],requestBody:{required:!1,content:{"application/json":{schema:{type:"object",properties:{productId:{type:"string",description:"Product ID (optional, auto-detected)"}}}}}},responses:{200:{description:"License activated successfully from Envato file",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string"},productId:{type:"string"},purchaseCode:{type:"string"},licensee:{type:"string"}}}}}},400:{description:"No Envato license file found"},401:{description:"Unauthorized, admin permission required"},500:{description:"Internal server error"}},requiresAuth:!0,logModule:"ADMIN_SYS",logTitle:"Activate license from file"};exports.default=async e=>{var t;const{ctx:i}=e;null==i||i.step("Looking for Envato license file");const r=await(0,utils_1.getProduct)(),s=(null===(t=e.body)||void 0===t?void 0:t.productId)||r.productId||r.id,o=(0,security_1.getValidator)(s),n=await o.getEnvatoLicenseInfo();if(!n)throw(0,error_1.createError)({statusCode:400,message:"No Envato license file found. Please download your license from Envato and place it in the /lic folder, or enter your purchase code manually."});null==i||i.step("Found Envato license file");null==i||i.step("Activating license with Envato");const a=await(0,utils_1.activateLicense)(s,n.purchaseCode,n.authorUsername||"auto");(0,Middleware_1.clearExtensionLicenseCache)();null==i||i.success("License activated from Envato file");return{success:!0,...a,productId:s,purchaseCode:n.purchaseCode.substring(0,8)+"...",licensee:n.licensee}};