"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const notification_1=require("@b/services/notification"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Test Email Notification",description:"Send a test email notification to verify the email channel is configured correctly",operationId:"testEmailNotification",tags:["Admin","Notification","Testing"],requiresAuth:!0,permission:"access.notification.settings",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{userId:{type:"string",description:"User ID to send test notification to (defaults to current user)"},email:{type:"string",format:"email",description:"Override email address for testing"}}}}}},responses:{200:{description:"Test email sent successfully",content:{"application/json":{schema:{type:"object",properties:{success:{type:"boolean"},message:{type:"string"},notificationId:{type:"string"},delivered:{type:"boolean"}}}}}},401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse}};exports.default=async e=>{var i,t,s,o;const{body:n,user:r,ctx:a}=e;try{null===(i=null==a?void 0:a.step)||void 0===i||i.call(a,"Sending test email notification");const e=n.userId||(null==r?void 0:r.id);if(!e)throw new Error("User ID is required");const o=await notification_1.notificationService.send({userId:e,type:"SYSTEM",channels:["EMAIL"],data:{title:"Test Email Notification",message:"This is a test email from the notification service. If you received this, your email channel is working correctly!",testMode:!0,timestamp:(new Date).toISOString(),...n.email&&{overrideEmail:n.email}},priority:"NORMAL",idempotencyKey:`test-email-${e}-${Date.now()}`});null===(t=null==a?void 0:a.success)||void 0===t||t.call(a,"Test email notification sent");const c=o.channelsFailed.includes("EMAIL"),l=c&&(null===(s=o.errors)||void 0===s?void 0:s.EMAIL)?o.errors.EMAIL:c?"EMAIL channel not configured or not registered":void 0;return{success:o.success&&!c,message:c?l||"Failed to send test email":"Test email sent successfully",notificationId:o.notificationId,delivered:o.channelsDelivered.includes("EMAIL"),channels:{delivered:o.channelsDelivered,failed:o.channelsFailed}}}catch(e){null===(o=null==a?void 0:a.fail)||void 0===o||o.call(a,e.message);throw e}};