"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const notification_1=require("@b/services/notification"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Test In-App Notification",description:"Send a test in-app notification to verify the in-app channel is configured correctly",operationId:"testInAppNotification",tags:["Admin","Notification","Testing"],requiresAuth:!0,permission:"access.notification.settings",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{userId:{type:"string",description:"User ID to send test notification to (defaults to current user)"}}}}}},responses:{200:{description:"Test in-app notification sent successfully",content:{"application/json":{schema:{type:"object",properties:{success:{type:"boolean"},message:{type:"string"},notificationId:{type:"string"},delivered:{type:"boolean"}}}}}},401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse}};exports.default=async e=>{var t,i,n;const{body:s,user:o,ctx:r}=e;try{null===(t=null==r?void 0:r.step)||void 0===t||t.call(r,"Sending test in-app notification");const e=s.userId||(null==o?void 0:o.id);if(!e)throw new Error("User ID is required");const n=await notification_1.notificationService.send({userId:e,type:"SYSTEM",channels:["IN_APP"],data:{title:"Test In-App Notification",message:"This is a test in-app notification from the notification service. If you see this, your in-app channel is working correctly!",link:"/admin/notifications",testMode:!0,timestamp:(new Date).toISOString()},priority:"NORMAL",idempotencyKey:`test-in-app-${e}-${Date.now()}`});null===(i=null==r?void 0:r.success)||void 0===i||i.call(r,"Test in-app notification sent");return{success:n.success,message:n.success?"Test in-app notification sent successfully":"Failed to send test in-app notification",notificationId:n.notificationId,delivered:n.channelsDelivered.includes("IN_APP"),channels:{delivered:n.channelsDelivered,failed:n.channelsFailed}}}catch(e){null===(n=null==r?void 0:r.fail)||void 0===n||n.call(r,e.message);throw e}};