"use strict";function getPublicDir(){if("production"===process.env.NODE_ENV){const e=[path_1.default.join(process.cwd(),"frontend","public"),path_1.default.join(process.cwd(),"public"),path_1.default.join(process.cwd(),"..","frontend","public")];for(const t of e)if(fs_1.default.existsSync(t))return t;return e[0]}return path_1.default.join(process.cwd(),"..","frontend","public")}var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const error_1=require("@b/utils/error"),console_1=require("@b/utils/console"),promises_1=__importDefault(require("fs/promises")),fs_1=__importDefault(require("fs")),path_1=__importDefault(require("path"));exports.metadata={summary:"Delete PWA screenshot or splash screen",operationId:"deletePwaScreenshot",tags:["Admin","System","PWA"],requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{path:{type:"string",description:"Path to the file to delete (relative to public)"}},required:["path"]}}}},responses:{200:{description:"Screenshot deleted successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string"}}}}}},400:{description:"Invalid path"},404:{description:"File not found"},500:{description:"Internal server error"}},permission:"edit.settings",requiresAuth:!0,logModule:"ADMIN_SYS",logTitle:"Delete PWA screenshot"};exports.default=async e=>{const{body:t,ctx:s}=e,{path:r}=t;if(!r)throw(0,error_1.createError)({statusCode:400,message:"File path is required"});if(!r.startsWith("/img/screenshots/")&&!r.startsWith("/img/splash/"))throw(0,error_1.createError)({statusCode:400,message:"Invalid file path. Can only delete from screenshots or splash directories."});try{null==s||s.step(`Deleting file: ${r}`);const e=getPublicDir(),t=path_1.default.join(e,r);if(!fs_1.default.existsSync(t))throw(0,error_1.createError)({statusCode:404,message:"File not found"});await promises_1.default.unlink(t);const o=t.replace(/\.(png|jpg|jpeg)$/,".webp");fs_1.default.existsSync(o)&&await promises_1.default.unlink(o);const i=t.replace(/\.webp$/,".png");t.endsWith(".webp")&&fs_1.default.existsSync(i)&&await promises_1.default.unlink(i);console_1.logger.info("PWA",`Screenshot deleted: ${r}`);null==s||s.success("Screenshot deleted successfully");return{message:"Screenshot deleted successfully"}}catch(e){console_1.logger.error("PWA","Failed to delete screenshot",e);null==s||s.fail(`Failed to delete screenshot: ${null==e?void 0:e.message}`);if(e.statusCode)throw e;throw(0,error_1.createError)({statusCode:500,message:`Failed to delete screenshot: ${null==e?void 0:e.message}`})}};