"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const utils_1=require("@b/api/admin/system/utils");exports.metadata={summary:"Batch check for updates for all products",operationId:"batchCheckProductUpdates",tags:["Admin","System"],permission:"create.license",responses:{200:{description:"Batch update check completed successfully",content:{"application/json":{schema:{type:"object",properties:{status:{type:"boolean",description:"Indicates if the batch check was successful"},message:{type:"string",description:"Status message"},products:{type:"array",description:"Array of products with their update status",items:{type:"object",properties:{productId:{type:"string"},currentVersion:{type:"string"},latestVersion:{type:"string"},updateAvailable:{type:"boolean"},updateId:{type:"string"},changelog:{type:"string"}}}}}}}}},401:{description:"Unauthorized, admin permission required"},500:{description:"Internal server error"}},logModule:"ADMIN_SYS",logTitle:"Batch check product updates"};exports.default=async t=>{const{ctx:e}=t;null==e||e.step("Checking updates for all products");const s=await(0,utils_1.fetchAllProductsUpdates)();if(s.products&&s.products.length>0){const t=s.products.filter(t=>t.updateAvailable).length;null==e||e.success(`Found ${t} updates available out of ${s.products.length} products`)}else null==e||e.success("All products are up to date");return s};