"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const utils_1=require("@b/api/admin/system/utils");exports.metadata={summary:"Checks for the latest version of a product",operationId:"checkLatestProductVersion",tags:["Admin","System"],requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{productId:{type:"string",description:"Product ID to check"}},required:["productId"]}}}},permission:"create.license",responses:{200:{description:"Latest version fetched successfully",content:{"application/json":{schema:{type:"object",properties:{latestVersion:{type:"string",description:"Latest version of the product"}}}}}},401:{description:"Unauthorized, admin permission required"},500:{description:"Internal server error"}},requiresAuth:!0,logModule:"ADMIN_SYS",logTitle:"Check latest product version"};exports.default=async e=>{const{ctx:t}=e;null==t||t.step(`Checking latest version for product ${e.body.productId}`);const s=await(0,utils_1.checkLatestVersion)(e.body.productId);null==t||t.success(`Latest version: ${s.latestVersion||"Unknown"}`);return s};