"use strict";async function findUserByEmail(e){const t=await db_1.models.user.findOne({where:{email:e},include:{model:db_1.models.twoFactor,as:"twoFactor"}});if(!t||!t.password)throw(0,error_1.createError)({statusCode:401,message:"Incorrect email or password"});if("BANNED"===t.status)throw(0,error_1.createError)({statusCode:403,message:"Your account has been banned. Please contact support."});if("SUSPENDED"===t.status)throw(0,error_1.createError)({statusCode:403,message:"Your account is suspended. Please contact support."});if("INACTIVE"===t.status)throw(0,error_1.createError)({statusCode:403,message:"Your account is inactive. Please verify your email or contact support."});return t}async function handleEmailVerification(e){const t=cache_1.CacheManager.getInstance();if("true"===await t.getSetting("verifyEmailStatus")&&!e.emailVerified&&e.email){await(0,utils_1.sendEmailVerificationToken)(e.id,e.email);throw(0,error_1.createError)({statusCode:400,message:"User email not verified. Verification email sent."})}}async function validatePassword(e,t){if(!await(0,passwords_1.verifyPassword)(e.password,t)){await incrementFailedLoginAttempts(e);throw(0,error_1.createError)({statusCode:401,message:"Incorrect email or password"})}}async function incrementFailedLoginAttempts(e){var t;await db_1.models.user.update({failedLoginAttempts:(null!==(t=e.failedLoginAttempts)&&void 0!==t?t:0)+1,lastFailedLogin:new Date},{where:{email:e.email}})}async function handleLoginAttempts(e){var t,r;const a=(0,date_fns_1.addMinutes)(null!==(t=e.lastFailedLogin)&&void 0!==t?t:0,5);if((null!==(r=e.failedLoginAttempts)&&void 0!==r?r:0)>=5&&a>new Date)throw(0,error_1.createError)({statusCode:403,message:"Too many failed login attempts, account temporarily blocked"});await resetFailedLoginAttempts(e)}async function resetFailedLoginAttempts(e){await db_1.models.user.update({failedLoginAttempts:0,lastFailedLogin:null},{where:{email:e.email}})}async function isTwoFactorRequired(e){var t;const r=cache_1.CacheManager.getInstance(),a=await r.getSetting("twoFactorStatus");return(null===(t=e.twoFactor)||void 0===t?void 0:t.enabled)&&"true"===a}async function handleTwoFactorAuthentication(e){var t;const r=null===(t=e.twoFactor)||void 0===t?void 0:t.type;otplib_1.authenticator.options={window:2};const a=otplib_1.authenticator.generate(e.twoFactor.secret);switch(r){case"SMS":await sendSmsOtp(e.phone,a);break;case"EMAIL":await sendEmailOtp(e.email,e.firstName,a);break;case"APP":break;default:throw(0,error_1.createError)({statusCode:400,message:"Invalid 2FA type"})}return{twoFactor:{enabled:!0,type:r},id:e.id,message:"2FA required"}}async function sendSmsOtp(e,t){if("true"!==process.env.NEXT_PUBLIC_2FA_SMS_STATUS||!process.env.APP_TWILIO_VERIFY_SERVICE_SID)throw(0,error_1.createError)({statusCode:400,message:"SMS 2FA is not enabled"});const r=(0,(await Promise.resolve().then(()=>__importStar(require("twilio")))).default)(constants_1.APP_TWILIO_ACCOUNT_SID,constants_1.APP_TWILIO_AUTH_TOKEN);await r.messages.create({body:`Your OTP code is: ${t}`,from:process.env.APP_TWILIO_PHONE_NUMBER,to:e})}async function sendEmailOtp(e,t,r){if("true"!==process.env.NEXT_PUBLIC_2FA_EMAIL_STATUS)throw(0,error_1.createError)({statusCode:400,message:"Email 2FA is not enabled"});await emails_1.emailQueue.add({emailData:{TO:e,FIRSTNAME:t,TOKEN:r},emailType:"OTPTokenVerification"})}var __createBinding=this&&this.__createBinding||(Object.create?function(e,t,r,a){void 0===a&&(a=r);var s=Object.getOwnPropertyDescriptor(t,r);s&&!("get"in s?!t.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return t[r]}});Object.defineProperty(e,a,s)}:function(e,t,r,a){void 0===a&&(a=r);e[a]=t[r]}),__setModuleDefault=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),__importStar=this&&this.__importStar||function(){var e=function(t){e=Object.getOwnPropertyNames||function(e){var t=[];for(var r in e)Object.prototype.hasOwnProperty.call(e,r)&&(t[t.length]=r);return t};return e(t)};return function(t){if(t&&t.__esModule)return t;var r={};if(null!=t)for(var a=e(t),s=0;s<a.length;s++)"default"!==a[s]&&__createBinding(r,t,a[s]);__setModuleDefault(r,t);return r}}();Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const constants_1=require("@b/utils/constants"),error_1=require("@b/utils/error"),passwords_1=require("@b/utils/passwords"),db_1=require("@b/db"),date_fns_1=require("date-fns"),otplib_1=require("otplib"),utils_1=require("../utils"),emails_1=require("@b/utils/emails"),cache_1=require("@b/utils/cache");exports.metadata={summary:"Logs in a user",description:"Logs in a user and returns a session token",operationId:"loginUser",tags:["Auth"],requiresAuth:!1,logModule:"LOGIN",logTitle:"Flutter app login",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{email:{type:"string",format:"email",description:"Email of the user"},password:{type:"string",description:"Password of the user"}},required:["email","password"]}}}},responses:{200:{description:"User logged in successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Success message"},twoFactor:{type:"object",properties:{enabled:{type:"boolean",description:"2FA enabled status"},type:{type:"string",description:"Type of 2FA"}}},id:{type:"string",description:"User ID"}}}}}},400:{description:"Invalid request (e.g., invalid email or password)"},401:{description:"Unauthorized (e.g., incorrect email or password)"}}};exports.default=async e=>{const{body:t,ctx:r}=e,{email:a,password:s}=t;try{null==r||r.step("Validating login credentials");if(!a||!s){null==r||r.fail("Email and password are required");throw(0,error_1.createError)({statusCode:400,message:"Email and password are required"})}null==r||r.step(`Looking up user: ${a}`);const e=await findUserByEmail(a);null==r||r.step("Checking email verification status");await handleEmailVerification(e);null==r||r.step("Verifying password");await validatePassword(e,s);null==r||r.step("Checking login attempts");await handleLoginAttempts(e);if(await isTwoFactorRequired(e)){null==r||r.step("2FA required, sending verification code","warn");return await handleTwoFactorAuthentication(e)}null==r||r.step("Generating session tokens");const t=await(0,utils_1.returnUserWithTokens)({user:e,message:"You have been logged in successfully"});null==r||r.success(`User ${a} logged in successfully (Flutter)`);return t}catch(e){null==r||r.fail(e.message||"Login failed");throw e}};