"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),sequelize_1=require("sequelize"),query_1=require("@b/utils/query"),utils_1=require("./utils");exports.metadata={summary:"Lists categories with post count",description:"This endpoint retrieves all categories that have at least one published post along with the count of their associated posts.",operationId:"getCategories",tags:["Blog"],requiresAuth:!1,logModule:"BLOG",logTitle:"Get Categories",responses:{200:{description:"Categories retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:{...utils_1.baseCategorySchema,postCount:{type:"number"}}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Category"),500:query_1.serverErrorResponse}};exports.default=async e=>{const{ctx:t}=e;null==t||t.step("Fetching categories with post counts");const s=await db_1.models.category.findAll({attributes:{include:[[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("posts.id")),"postCount"]]},include:[{model:db_1.models.post,as:"posts",attributes:[],where:{status:"PUBLISHED"},required:!0}],group:["category.id"]});null==t||t.success(`Retrieved ${s.length} categories`);return s.map(e=>e.get({plain:!0}))};