"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const error_1=require("@b/utils/error"),query_1=require("@b/utils/query"),BinaryOrderService_1=require("./util/BinaryOrderService"),cache_1=require("@b/utils/cache");exports.metadata={summary:"Create Binary Order",operationId:"createBinaryOrder",tags:["Binary","Orders"],description:"Creates a new binary order for the authenticated user. Requires an idempotency-key header to prevent duplicate orders on network retries.",parameters:[{name:"idempotency-key",in:"header",required:!0,schema:{type:"string"},description:"Unique key to prevent duplicate order creation on retries. If an order with this key already exists for the user, the existing order will be returned instead of creating a duplicate."}],requestBody:{description:"Binary order data to be created.",content:{"application/json":{schema:{type:"object",properties:{currency:{type:"string"},pair:{type:"string"},amount:{type:"number"},side:{type:"string"},closedAt:{type:"string",format:"date-time"},durationId:{type:"string"},isDemo:{type:"boolean"},type:{type:"string"},durationType:{type:"string"},barrier:{type:"number"},barrierLevelId:{type:"string"},strikePrice:{type:"number"},strikeLevelId:{type:"string"},payoutPerPoint:{type:"number"}},required:["currency","pair","amount","side","closedAt","durationId","type"]}}},required:!0},responses:(0,query_1.createRecordResponses)("Binary Order"),requiresAuth:!0,rateLimit:{windowMs:6e4,max:10},logModule:"BINARY",logTitle:"Create binary order"};exports.default=async e=>{const{user:r,body:t,ctx:i,headers:a}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const{isDemo:s}=t,n=cache_1.CacheManager.getInstance(),o="true"===await n.getSetting("binaryStatus"),d="true"===await n.getSetting("binaryPracticeStatus");if(!o)throw(0,error_1.createError)({statusCode:403,message:"Binary trading is currently disabled"});if(s&&!d)throw(0,error_1.createError)({statusCode:403,message:"Binary practice mode is currently disabled"});const c=null==a?void 0:a["idempotency-key"];if(!c)throw(0,error_1.createError)({statusCode:400,message:"Missing idempotency-key header. This header is required to prevent duplicate orders."});const{currency:u,pair:y,amount:p,side:l,type:m,durationId:g,durationType:h,barrier:b,barrierLevelId:v,strikePrice:w,strikeLevelId:f,payoutPerPoint:k,closedAt:q}=t;try{null==i||i.step("Validating order parameters");null==i||i.step(`Checking wallet balance for ${y}`);null==i||i.step("Fetching market data and binary duration");null==i||i.step(`Deducting ${p} ${y} from wallet`);null==i||i.step("Fetching current market price");null==i||i.step("Creating binary order record");const e=await BinaryOrderService_1.BinaryOrderService.createOrder({userId:r.id,currency:u,pair:y,amount:p,side:l,type:m,durationId:g,durationType:h,barrier:b,barrierLevelId:v,strikePrice:w,strikeLevelId:f,payoutPerPoint:k,closedAt:q,isDemo:s,idempotencyKey:c});null==i||i.step("Scheduling order expiry processing");null==i||i.success(`Opened ${l} ${s?"DEMO":""} position on ${u}/${y} for ${p} ${y}`);return{order:e,message:"Binary order created successfully"}}catch(e){null==i||i.fail(e.message||"Failed to create binary order");throw(0,error_1.createError)({statusCode:(null==e?void 0:e.statusCode)||500,message:e.message||"An error occurred while creating the order"})}};