"use strict";function validateAndNormalizeTimestamps(e,t){const a=Date.now(),r=new Date("2020-01-01").getTime(),o=a+36e5;if(e>o||t>o){console_1.logger.warn("CHART",`Invalid future timestamps detected: from=${e}, to=${t}, now=${a}`);if(e>10*o){return{from:a-3e7,to:a,isValid:!1}}}const n=Math.max(e,r),i=Math.min(t,a+6e4);return{from:n,to:i,isValid:n<i}}function getCacheKey(e,t){return`ohlcv:${e}:${t}`}function compress(e){return zlib_1.default.gzipSync(JSON.stringify(e))}function decompress(e){return JSON.parse(zlib_1.default.gunzipSync(e).toString())}function getCacheFilePath(e,t){const a=path_1.default.join(cacheDirPath,e);fs_1.default.existsSync(a)||fs_1.default.mkdirSync(a,{recursive:!0});return path_1.default.join(a,`${t}.json.gz`)}async function loadCacheFromFile(e,t){const a=getCacheFilePath(e,t);if(fs_1.default.existsSync(a))try{const r=decompress(await fs_1.default.promises.readFile(a));if(Array.isArray(r)&&r.length>0){const a=r[0];if(Array.isArray(a)&&a.length>=5&&"number"==typeof a[0])return r;console_1.logger.warn("CHART",`Invalid cache data format for ${e}/${t}, clearing cache`)}}catch(a){console_1.logger.warn("CHART",`Failed to load cache file for ${e}/${t}: ${a}`)}return[]}async function saveCacheToFile(e,t,a){const r=getCacheFilePath(e,t),o=compress(a);await fs_1.default.promises.writeFile(r,o)}function getGapFillKey(e,t){return`gapfill:${e}:${t}`}function isGapFillInProgress(e,t){const a=getGapFillKey(e,t);return gapFillLocks.has(a)}async function waitForGapFill(e,t){const a=getGapFillKey(e,t);if(gapFillLocks.has(a)){console_1.logger.debug("CHART",`Waiting for existing gap fill operation for ${e}/${t}`);return await gapFillLocks.get(a)||null}return null}function registerGapFillOperation(e,t,a){const r=getGapFillKey(e,t),o=activeGapFills.get(r);if(o){if(Date.now()-o.startTime<3e4){if(a.some(e=>o.gaps.some(t=>e.gapStart<t.gapEnd&&e.gapEnd>t.gapStart))){console_1.logger.debug("CHART",`Skipping duplicate gap fill for ${e}/${t} - operation already in progress`);return!1}}}activeGapFills.set(r,{startTime:Date.now(),gaps:a});return!0}function clearGapFillOperation(e,t){const a=getGapFillKey(e,t);activeGapFills.delete(a)}async function executeWithGapFillLock(e,t,a){const r=getGapFillKey(e,t);if(gapFillLocks.has(r)){console_1.logger.debug("CHART",`Waiting for existing gap fill lock for ${e}/${t}`);await gapFillLocks.get(r)}const o=a();gapFillLocks.set(r,o);try{return await o}finally{gapFillLocks.delete(r)}}async function getCachedOHLCV(e,t,a,r){const o=getCacheKey(e,t);cacheLocks.has(o)&&await cacheLocks.get(o);try{let n=await Promise.race([redis.get(o),new Promise((e,t)=>setTimeout(()=>t(new Error("Redis timeout")),3e3))]).catch(()=>null);if(!n){const a=loadCacheFromFileWithLock(e,t,o);cacheLocks.set(o,a);try{const e=await a;if(!(e.length>0))return[];await Promise.race([redis.set(o,JSON.stringify(e)),new Promise((e,t)=>setTimeout(()=>t(new Error("Redis SET timeout")),3e3))]).catch(()=>{console_1.logger.warn("CHART",`Failed to cache data in Redis for ${o}`)});n=JSON.stringify(e)}finally{cacheLocks.delete(o)}}const i=JSON.parse(n),s=binarySearch(i,a),l=binarySearch(i,r,!0);return i.slice(s,l+1)}catch(e){console_1.logger.error("CHART",`Error getting cached OHLCV for ${o}: ${e}`);return[]}}async function loadCacheFromFileWithLock(e,t,a){try{return await loadCacheFromFile(e,t)}catch(e){console_1.logger.error("CHART",`Error loading cache from file for ${a}: ${e}`);return[]}}function binarySearch(e,t,a=!1){let r=0,o=e.length-1;for(;r<=o;){const a=Math.floor((r+o)/2);if(e[a][0]===t)return a;e[a][0]<t?r=a+1:o=a-1}return a?o:r}async function saveOHLCVToCache(e,t,a){const r=getCacheKey(e,t);cacheLocks.has(r)&&await cacheLocks.get(r);const o=performCacheSave(e,t,a,r);cacheLocks.set(r,o);try{await o}finally{cacheLocks.delete(r)}}async function performCacheSave(e,t,a,r){try{let o=[];const n=await Promise.race([redis.get(r),new Promise((e,t)=>setTimeout(()=>t(new Error("Redis GET timeout")),3e3))]).catch(()=>null);if(n)try{o=JSON.parse(n)}catch(e){console_1.logger.warn("CHART",`Failed to parse cached data for ${r}, using empty array`);o=[]}const i=mergeAndSortData(o,a);await Promise.race([redis.set(r,JSON.stringify(i)),new Promise((e,t)=>setTimeout(()=>t(new Error("Redis SET timeout")),3e3))]).catch(e=>{console_1.logger.warn("CHART",`Failed to save cache to Redis for ${r}: ${e}`)});await Promise.race([saveCacheToFile(e,t,i),new Promise((e,t)=>setTimeout(()=>t(new Error("File save timeout")),5e3))]).catch(e=>{console_1.logger.warn("CHART",`Failed to save cache to file for ${r}: ${e}`)})}catch(e){console_1.logger.error("CHART",`Error in performCacheSave for ${r}: ${e}`);throw e}}function mergeAndSortData(e,t){const a=[...e,...t];a.sort((e,t)=>e[0]-t[0]);return a.filter((e,t,a)=>0===t||e[0]!==a[t-1][0])}function intervalToMilliseconds(e){return{"1m":6e4,"3m":18e4,"5m":3e5,"15m":9e5,"30m":18e5,"1h":36e5,"2h":72e5,"4h":144e5,"6h":216e5,"8h":288e5,"12h":432e5,"1d":864e5,"3d":2592e5,"1w":6048e5,"1M":2592e6}[e]||0}function findGapsInCachedData(e,t,a,r){const o=[],n=Date.now(),i=intervalToMilliseconds(r);let s=Math.floor(t/i)*i;const l=Math.floor(n/i)*i,c=Math.min(a,l);console_1.logger.debug("CHART",`findGaps: now=${new Date(n).toISOString()}, currentCandleStart=${new Date(l).toISOString()}, adjustedTo=${new Date(c).toISOString()}`);for(const t of e){const e=t[0];e>s+1.5*i&&o.push({gapStart:s,gapEnd:e});s=e+i}if(s<c){const t=Math.round((c-s)/6e4),a=e.length>0?e[e.length-1][0]:0;console_1.logger.debug("CHART",`Gap at end: lastCached=${new Date(a).toISOString()}, nextExpected=${new Date(s).toISOString()}, adjustedTo=${new Date(c).toISOString()}, gap=${t} minutes`);o.push({gapStart:s,gapEnd:c})}return o}function fillGapsWithSyntheticCandles(e,t,a,r){if(0===e.length)return e;const o=intervalToMilliseconds(r),n=Date.now(),i=Math.min(a,n),s=[];let l=e[0][4],c=Math.floor(t/o)*o,h=0;for(;c<i&&h<=e.length;){if(h<e.length){const t=e[h],a=t[0];if(Math.abs(a-c)<.5*o){s.push(t);l=t[4];h++;c=a+o;continue}if(a<c){h++;continue}}(h<e.length?(e[h][0]-c)/o:(i-c)/o)<=50&&s.push([c,l,l,l,l,0]);c+=o;if(s.length>1e4){console_1.logger.warn("CHART",`Too many candles generated, stopping at ${s.length}`);break}}return s}function validateAndCleanCandles(e){const t=Date.now(),a=new Date("2015-01-01").getTime();return removeAnomalousCandles(e.filter(e=>{if(!Array.isArray(e)||e.length<5)return!1;const[r,o,n,i,s]=e;return!("number"!=typeof r||r<a||r>t+36e5)&&("number"==typeof o&&"number"==typeof n&&"number"==typeof i&&"number"==typeof s&&(!(n<i||n<o||n<s||i>o||i>s)&&(!!(isFinite(o)&&isFinite(n)&&isFinite(i)&&isFinite(s))&&!(o<=0||n<=0||i<=0||s<=0))))}))}function removeAnomalousCandles(e){if(e.length<3)return e;const t=[...e].sort((e,t)=>e[0]-t[0]),a=[],r=[];for(let e=1;e<t.length;e++){const o=t[e-1][4],n=t[e][1],i=Math.abs(n-o);a.push(i);const s=t[e][2]-t[e][3];r.push(s)}const o=[...a].sort((e,t)=>e-t),n=o[Math.floor(o.length/2)]||0,i=a.reduce((e,t)=>e+t,0)/a.length||0,s=[...r].sort((e,t)=>e-t),l=s[Math.floor(s.length/2)]||0,c=r.reduce((e,t)=>e+t,0)/r.length||0,h=Math.max(10*n,5*i),g=Math.max(10*l,5*c),u=[];let d=0;for(let e=0;e<t.length;e++){const a=t[e],[r,o,n,i,s]=a,l=n-i;let c=!1,f="";if(e>0){const a=t[e-1][4],r=Math.abs(o-a);if(h>0&&r>h&&e<t.length-1){const o=t[e+1][1],n=Math.abs(o-s);if(Math.abs(o-a)<.5*n){c=!0;f=`gap from prev: ${r.toFixed(2)} > threshold ${h.toFixed(2)}, next candle reverts`}}}if(!c&&g>0&&l>g){const a=[];for(let r=Math.max(0,e-3);r<Math.min(t.length,e+4);r++)r!==e&&a.push(t[r][2]-t[r][3]);if(a.length>0){const e=a.reduce((e,t)=>e+t,0)/a.length;if(l>8*e){c=!0;f=`range ${l.toFixed(2)} > 8x neighbor avg ${e.toFixed(2)}`}}}if(!c){const a=Math.abs(s-o),r=n-Math.max(o,s),l=Math.min(o,s)-i;if(a>0&&(r>20*a||l>20*a)){const a=[];for(let r=Math.max(0,e-3);r<Math.min(t.length,e+4);r++)r!==e&&a.push(t[r][2]-t[r][3]);if(a.length>0){const e=a.reduce((e,t)=>e+t,0)/a.length,t=Math.max(r,l);if(t>5*e){c=!0;f=`extreme wick: ${t.toFixed(2)} > 5x neighbor range ${e.toFixed(2)}`}}}}if(c){console_1.logger.warn("CHART",`Removing anomalous candle: time=${new Date(r).toISOString()}, O=${o.toFixed(2)}, H=${n.toFixed(2)}, L=${i.toFixed(2)}, C=${s.toFixed(2)}, reason: ${f}`);d++}else u.push(a)}d>0&&console_1.logger.info("CHART",`Removed ${d} anomalous candles from dataset`);return u}function repairCandleData(e,t){if(e.length<2)return e;const a=intervalToMilliseconds(t),r=[...e].sort((e,t)=>e[0]-t[0]),o=[];for(let e=0;e<r.length;e++){const t=r[e];o.push(t);if(e<r.length-1){const n=r[e+1],i=n[0]-t[0],s=Math.round(i/a)-1;if(s>0&&s<=3){const e=t[4],r=n[1];for(let n=1;n<=s;n++){const i=e+(r-e)*(n/(s+1)),l=t[0]+a*n;o.push([l,i,i,i,i,0])}console_1.logger.debug("CHART",`Interpolated ${s} missing candles between ${new Date(t[0]).toISOString()} and ${new Date(n[0]).toISOString()}`)}}}return o.sort((e,t)=>e[0]-t[0])}var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.baseChartDataPointSchema=void 0;exports.validateAndNormalizeTimestamps=validateAndNormalizeTimestamps;exports.isGapFillInProgress=isGapFillInProgress;exports.waitForGapFill=waitForGapFill;exports.registerGapFillOperation=registerGapFillOperation;exports.clearGapFillOperation=clearGapFillOperation;exports.executeWithGapFillLock=executeWithGapFillLock;exports.getCachedOHLCV=getCachedOHLCV;exports.saveOHLCVToCache=saveOHLCVToCache;exports.intervalToMilliseconds=intervalToMilliseconds;exports.findGapsInCachedData=findGapsInCachedData;exports.fillGapsWithSyntheticCandles=fillGapsWithSyntheticCandles;exports.validateAndCleanCandles=validateAndCleanCandles;exports.repairCandleData=repairCandleData;const fs_1=__importDefault(require("fs")),path_1=__importDefault(require("path")),zlib_1=__importDefault(require("zlib")),redis_1=require("@b/utils/redis"),schema_1=require("@b/utils/schema"),console_1=require("@b/utils/console"),redis=redis_1.RedisSingleton.getInstance(),cacheDirPath=path_1.default.resolve(process.cwd(),"data","chart");fs_1.default.existsSync(cacheDirPath)||fs_1.default.mkdirSync(cacheDirPath,{recursive:!0});exports.baseChartDataPointSchema={timestamp:(0,schema_1.baseNumberSchema)("Timestamp for the data point"),open:(0,schema_1.baseNumberSchema)("Opening price for the data interval"),high:(0,schema_1.baseNumberSchema)("Highest price during the data interval"),low:(0,schema_1.baseNumberSchema)("Lowest price during the data interval"),close:(0,schema_1.baseNumberSchema)("Closing price for the data interval"),volume:(0,schema_1.baseNumberSchema)("Volume of trades during the data interval")};const cacheLocks=new Map,gapFillLocks=new Map,activeGapFills=new Map;