"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),sequelize_1=require("sequelize"),query_1=require("@b/utils/query"),error_1=require("@b/utils/error"),console_1=require("@b/utils/console");exports.metadata={summary:"Check 2Checkout payment status",description:"Retrieves the current status of a 2Checkout payment using the order reference",operationId:"check2CheckoutStatus",tags:["Finance","Deposit"],parameters:[{name:"orderReference",in:"query",required:!0,schema:{type:"string"},description:"2Checkout order reference to check status for"}],responses:{200:{description:"Payment status retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{status:{type:"string",enum:["PENDING","COMPLETED","FAILED"],description:"Current transaction status"},transaction:{type:"object",description:"Transaction details"},paymentDetails:{type:"object",description:"2Checkout payment details from metadata"}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Transaction"),500:query_1.serverErrorResponse},requiresAuth:!0};exports.default=async e=>{var r;const{user:t,query:s}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const{orderReference:a}=s;if(!a)throw(0,error_1.createError)({statusCode:400,message:"Order reference is required"});try{const e=await db_1.models.transaction.findOne({where:{userId:t.id,description:{[sequelize_1.Op.like]:`%${a}%`},type:"DEPOSIT"},include:[{model:db_1.models.wallet,as:"wallet",attributes:["id","currency","balance"]}],order:[["createdAt","DESC"]]});if(!e)throw(0,error_1.createError)({statusCode:404,message:"Transaction not found"});let s={};try{const r=JSON.parse(e.metadata||"{}");s={gateway:r.gateway,refNo:r.refNo,orderNo:r.orderNo,externalReference:r.externalReference,orderStatus:r.orderStatus,paymentStatus:r.paymentStatus,processedAt:r.processedAt,verifiedAt:r.verifiedAt,failureReason:r.failureReason}}catch(e){console_1.logger.error("2CHECKOUT","Error parsing transaction metadata",e)}return{status:e.status,transaction:{id:e.id,amount:e.amount,fee:e.fee,currency:null===(r=e.wallet)||void 0===r?void 0:r.currency,description:e.description,createdAt:e.createdAt,updatedAt:e.updatedAt},paymentDetails:s}}catch(e){if(e.statusCode)throw e;throw(0,error_1.createError)({statusCode:500,message:`Error checking payment status: ${e.message}`})}};