"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),sequelize_1=require("sequelize"),query_1=require("@b/utils/query"),error_1=require("@b/utils/error"),utils_1=require("./utils"),utils_2=require("@b/api/finance/utils");exports.metadata={summary:"Verifies a 2Checkout payment",description:"Verifies a 2Checkout payment using the order reference and updates the transaction status accordingly",operationId:"verify2CheckoutPayment",tags:["Finance","Deposit"],logModule:"2CHECKOUT_DEPOSIT",logTitle:"Verify 2Checkout payment",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{orderReference:{type:"string",description:"2Checkout order reference"},refNo:{type:"string",description:"2Checkout reference number"},signature:{type:"string",description:"2Checkout signature for verification"},status:{type:"string",description:"Payment status from 2Checkout"}},required:["orderReference","refNo"]}}}},responses:{200:{description:"Payment verification completed successfully",content:{"application/json":{schema:{type:"object",properties:{success:{type:"boolean"},transaction:{type:"object"},message:{type:"string"}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Transaction"),500:query_1.serverErrorResponse},requiresAuth:!0};exports.default=async e=>{const{user:t,body:r,ctx:s}=e;if(!(null==t?void 0:t.id)){null==s||s.fail("User not authenticated");throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"})}const{orderReference:a,refNo:o,signature:i,status:n}=r;try{const e=(0,utils_1.use2Checkout)(),r=await db_1.models.transaction.findOne({where:{userId:t.id,description:{[sequelize_1.Op.like]:`%${a}%`},status:"PENDING"},include:[{model:db_1.models.wallet,as:"wallet"}]});if(!r)throw(0,error_1.createError)({statusCode:404,message:"Transaction not found or already processed"});if(i){const t={orderReference:a,refNo:o,status:n||"COMPLETE"};if(!(0,utils_1.verify2CheckoutSignature)(t,i,e.secretKey))throw(0,error_1.createError)({statusCode:400,message:"Invalid signature"})}const u="COMPLETE"===n||"AUTHRECEIVED"===n;if(u){await r.update({status:"COMPLETED",metadata:JSON.stringify({...JSON.parse(r.metadata||"{}"),refNo:o,orderReference:a,gateway:"2checkout",verifiedAt:(new Date).toISOString()})});const e=r.wallet;e&&await(0,utils_2.processFiatDeposit)({userId:t.id,currency:e.currency,amount:parseFloat(r.amount),fee:parseFloat(r.fee||"0"),referenceId:o,method:"2CHECKOUT",description:`2Checkout deposit - ${r.amount} ${e.currency}`,metadata:{refNo:o,orderReference:a},idempotencyKey:`2checkout_deposit_${o}`,ctx:s})}else await r.update({status:"FAILED",metadata:JSON.stringify({...JSON.parse(r.metadata||"{}"),refNo:o,orderReference:a,gateway:"2checkout",failureReason:n,verifiedAt:(new Date).toISOString()})});return{success:u,transaction:await r.reload(),message:u?"Payment verified and processed successfully":`Payment failed with status: ${n}`}}catch(e){if(e.statusCode)throw e;throw(0,error_1.createError)({statusCode:500,message:`Error verifying 2Checkout payment: ${e.message}`})}};