"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),error_1=require("@b/utils/error"),console_1=require("@b/utils/console"),db_1=require("@b/db");exports.metadata={summary:"Checks Adyen payment status",description:"Retrieves the current status of an Adyen payment by transaction reference. This endpoint provides real-time payment status information for tracking and reconciliation purposes.",operationId:"checkAdyenPaymentStatus",tags:["Finance","Deposit"],parameters:[{name:"reference",in:"query",required:!0,schema:{type:"string",description:"Transaction reference to check status for"}}],responses:{200:{description:"Payment status retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{reference:{type:"string",description:"Transaction reference"},status:{type:"string",description:"Current payment status"},amount:{type:"number",description:"Payment amount"},currency:{type:"string",description:"Payment currency"},fee:{type:"number",description:"Transaction fee",nullable:!0},pspReference:{type:"string",description:"Adyen PSP reference",nullable:!0},sessionId:{type:"string",description:"Adyen session ID",nullable:!0},createdAt:{type:"string",description:"Transaction creation timestamp"},updatedAt:{type:"string",description:"Transaction last update timestamp"},metadata:{type:"object",description:"Additional transaction metadata"}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Transaction"),500:query_1.serverErrorResponse},requiresAuth:!0};exports.default=async e=>{const{user:t,query:r}=e;if(!t)throw(0,error_1.createError)({statusCode:401,message:"User not authenticated"});const{reference:n}=r;if(!n)throw(0,error_1.createError)({statusCode:400,message:"Transaction reference is required"});try{const e=await db_1.models.transaction.findOne({where:{uuid:n,userId:t.id,type:"DEPOSIT"}});if(!e)throw(0,error_1.createError)({statusCode:404,message:"Transaction not found"});const r=e.metadata;if("adyen"!==(null==r?void 0:r.gateway))throw(0,error_1.createError)({statusCode:400,message:"Transaction is not an Adyen payment"});return{reference:e.uuid,status:e.status,amount:e.amount,currency:(null==r?void 0:r.currency)||"USD",fee:e.fee,pspReference:(null==r?void 0:r.pspReference)||null,sessionId:(null==r?void 0:r.sessionId)||null,resultCode:(null==r?void 0:r.resultCode)||null,eventCode:(null==r?void 0:r.eventCode)||null,createdAt:e.createdAt,updatedAt:e.updatedAt,metadata:{gateway:null==r?void 0:r.gateway,originalAmount:null==r?void 0:r.originalAmount,feeAmount:null==r?void 0:r.feeAmount,countryCode:null==r?void 0:r.countryCode,verifiedAt:null==r?void 0:r.verifiedAt,verificationMethod:null==r?void 0:r.verificationMethod,webhookProcessedAt:null==r?void 0:r.webhookProcessedAt,captureProcessedAt:null==r?void 0:r.captureProcessedAt,captureSuccess:null==r?void 0:r.captureSuccess,cancelledAt:null==r?void 0:r.cancelledAt}}}catch(e){console_1.logger.error("ADYEN","Payment status check error",e);throw(0,error_1.createError)({statusCode:500,message:`Failed to check payment status: ${e.message}`})}};