"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),error_1=require("@b/utils/error"),console_1=require("@b/utils/console"),utils_1=require("./utils"),db_1=require("@b/db"),wallet_1=require("@b/services/wallet");exports.metadata={summary:"Checks iPay88 payment status",description:"Queries iPay88 for the current status of a payment transaction using the reference number. This endpoint can be used to check payment status when webhook notifications are not received.",operationId:"checkIpay88PaymentStatus",tags:["Finance","Payment"],parameters:[{name:"reference",in:"query",required:!0,schema:{type:"string"},description:"Transaction reference number"},{name:"amount",in:"query",required:!0,schema:{type:"number"},description:"Transaction amount"},{name:"currency",in:"query",required:!0,schema:{type:"string"},description:"Transaction currency"}],responses:{200:{description:"Payment status retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{success:{type:"boolean"},data:{type:"object",properties:{transaction_id:{type:"string"},reference:{type:"string"},status:{type:"string"},amount:{type:"number"},currency:{type:"string"},gateway:{type:"string"},ipay88_transaction_id:{type:"string"},auth_code:{type:"string"},response_message:{type:"string"},payment_method:{type:"string"},signature_valid:{type:"boolean"},last_updated:{type:"string"}}}}}}}},400:{description:"Bad request - Invalid parameters",content:{"application/json":{schema:{type:"object",properties:{error:{type:"string"},details:{type:"object"}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Transaction not found"),500:query_1.serverErrorResponse},requiresAuth:!0};exports.default=async e=>{var t,a;const{user:r,query:n}=e;if(!r)throw(0,error_1.createError)({statusCode:401,message:"User not found"});try{const{reference:e,amount:s,currency:o}=n;if(!e)throw(0,error_1.createError)({statusCode:400,message:"Reference number is required"});if(!s||isNaN(Number(s)))throw(0,error_1.createError)({statusCode:400,message:"Valid amount is required"});if(!o)throw(0,error_1.createError)({statusCode:400,message:"Currency is required"});const i=(0,utils_1.getIpay88Config)(),u=await db_1.models.transaction.findOne({where:{userId:r.id,metadata:{ipay88_reference:e}}});if(!u)throw(0,error_1.createError)({statusCode:404,message:`Transaction not found for reference: ${e}`});const c=Math.round(100*Number(s)).toString(),d=(0,utils_1.generateIpay88Signature)(i.merchantKey,i.merchantCode,e,c,o.toUpperCase()),y={MerchantCode:i.merchantCode,RefNo:e,Amount:c,Currency:o.toUpperCase(),Signature:d};try{const a=await(0,utils_1.makeIpay88Request)("/api/requery.asp","POST",y),r=new URLSearchParams(a),n={MerchantCode:r.get("MerchantCode")||"",PaymentId:r.get("PaymentId")||"",RefNo:r.get("RefNo")||"",Amount:r.get("Amount")||"",Currency:r.get("Currency")||"",Remark:r.get("Remark")||"",TransId:r.get("TransId")||"",AuthCode:r.get("AuthCode")||"",Status:r.get("Status")||"",ErrDesc:r.get("ErrDesc")||"",Signature:r.get("Signature")||"",CCName:r.get("CCName")||void 0,CCNo:r.get("CCNo")||void 0,S_bankname:r.get("S_bankname")||void 0,S_country:r.get("S_country")||void 0};if(!(0,utils_1.verifyIpay88Signature)(i.merchantKey,n.MerchantCode,n.PaymentId,n.RefNo,n.Amount,n.Currency,n.Status,n.Signature)){console_1.logger.error("IPAY88","Requery response signature verification failed",{reference:e,response:n});throw(0,error_1.createError)({statusCode:400,message:"Invalid signature in iPay88 response"})}const s=(0,utils_1.convertFromIpay88Amount)(n.Amount),o=utils_1.IPAY88_STATUS_MAPPING[n.Status]||"FAILED";if(u.status!==o){const t={status:o,metadata:{...u.metadata,ipay88_transaction_id:n.TransId,ipay88_auth_code:n.AuthCode,ipay88_status:n.Status,ipay88_error_desc:n.ErrDesc,ipay88_remark:n.Remark,signature_valid:!0,ipay88_requery_response:n,last_status_check:(new Date).toISOString()}};n.CCName||n.CCNo?t.metadata.payment_method_details={type:"credit_card",card_holder:n.CCName,masked_number:n.CCNo}:n.S_bankname&&(t.metadata.payment_method_details={type:"online_banking",bank_name:n.S_bankname,country:n.S_country});if("COMPLETED"===o&&"COMPLETED"!==u.status){const a=(await wallet_1.walletCreationService.getOrCreateWallet(u.userId,"FIAT",u.metadata.currency)).wallet,r=`ipay88_status_${u.id}`;await wallet_1.walletService.credit({idempotencyKey:r,userId:u.userId,walletId:a.id,walletType:"FIAT",currency:u.metadata.currency,amount:u.amount,operationType:"DEPOSIT",referenceId:e,description:`iPay88 deposit of ${u.amount} ${u.metadata.currency}`,metadata:{method:"IPAY88",transactionId:u.id}});t.metadata.wallet_updated=!0;t.metadata.wallet_updated_at=(new Date).toISOString()}await u.update(t)}const c=utils_1.IPAY88_RESPONSE_CODES[n.AuthCode]||n.ErrDesc||"Unknown response";return{success:!0,data:{transaction_id:u.id,reference:n.RefNo,status:o,amount:s,currency:n.Currency,gateway:"ipay88",ipay88_transaction_id:n.TransId,auth_code:n.AuthCode,response_message:c,payment_method:(null===(t=u.metadata.payment_method_details)||void 0===t?void 0:t.type)||"unknown",signature_valid:!0,last_updated:u.updatedAt,requery_timestamp:(new Date).toISOString()}}}catch(t){console_1.logger.warn("IPAY88",`Requery failed, returning current transaction status: ${t.message}`);return{success:!0,data:{transaction_id:u.id,reference:e,status:u.status,amount:u.amount,currency:u.metadata.currency,gateway:"ipay88",ipay88_transaction_id:u.metadata.ipay88_transaction_id||"",auth_code:u.metadata.ipay88_auth_code||"",response_message:"Status check from local database (requery unavailable)",payment_method:(null===(a=u.metadata.payment_method_details)||void 0===a?void 0:a.type)||"unknown",signature_valid:u.metadata.signature_valid||!1,last_updated:u.updatedAt,requery_error:t.message}}}}catch(e){console_1.logger.error("IPAY88","Status check error",e);if(e instanceof utils_1.Ipay88Error)throw(0,error_1.createError)({statusCode:400,message:`iPay88 Error: ${e.message}`});throw(0,error_1.createError)({statusCode:500,message:e.message||"Failed to check iPay88 payment status"})}};