"use strict";var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.convertFromIpay88Amount=exports.convertToIpay88Amount=exports.verifyIpay88Signature=exports.generateIpay88Signature=exports.Ipay88Error=exports.IPAY88_RESPONSE_CODES=exports.IPAY88_STATUS_MAPPING=exports.IPAY88_PAYMENT_METHODS=exports.validateCurrency=exports.makeIpay88Request=exports.getIpay88Config=void 0;const crypto_1=__importDefault(require("crypto")),error_1=require("@b/utils/error"),getIpay88Config=()=>{const e=process.env.APP_IPAY88_MERCHANT_CODE,r=process.env.APP_IPAY88_MERCHANT_KEY,t="production"===process.env.NODE_ENV;if(!e||!r)throw(0,error_1.createError)({statusCode:500,message:"iPay88 credentials are not properly configured in environment variables"});return{merchantCode:e,merchantKey:r,baseUrl:t?"https://payment.ipay88.com.my":"https://sandbox.ipay88.com.my",version:"1.6.1"}};exports.getIpay88Config=getIpay88Config;const makeIpay88Request=async(e,r="POST",t)=>{const o=`${(0,exports.getIpay88Config)().baseUrl}${e}`,a={method:r,headers:{"Content-Type":"application/x-www-form-urlencoded","User-Agent":"iPay88-API-Client/1.0"}};if(t&&("POST"===r||"PUT"===r)){const e=new URLSearchParams;Object.keys(t).forEach(r=>{void 0!==t[r]&&null!==t[r]&&e.append(r,t[r].toString())});a.body=e.toString()}try{const e=await fetch(o,a),r=await e.text();if(!e.ok)throw new Ipay88Error(`iPay88 API Error: ${e.status}`,e.status,{response:r});try{return JSON.parse(r)}catch(e){return r}}catch(e){if(e instanceof Ipay88Error)throw e;throw new Ipay88Error("Network error occurred",500,{message:e.message})}};exports.makeIpay88Request=makeIpay88Request;const validateCurrency=e=>["MYR","SGD","IDR","VND","THB","PHP","USD","EUR","GBP","AUD"].includes(e.toUpperCase());exports.validateCurrency=validateCurrency;exports.IPAY88_PAYMENT_METHODS={CREDIT_CARD:"2",FPXB2B:"6",FPXB2C:"8",ENETS:"10",SINGPOST:"11",WEBCASH:"13",CASH711:"14",BOOST:"33",GRABPAY:"64",MAYBANK_QR:"103",SHOPEE_PAY:"134",TOUCH_N_GO:"149",MAYBANK2U:"6",CIMB_CLICKS:"15",PUBLIC_BANK:"16",RHB_BANK:"17",HONG_LEONG:"18",AMBANK:"20",ALIPAY:"23",WECHAT_PAY:"134"};exports.IPAY88_STATUS_MAPPING={1:"COMPLETED",0:"FAILED","-1":"PENDING",2:"CANCELLED"};exports.IPAY88_RESPONSE_CODES={"00":"Successful","01":"Refer to card issuer","02":"Refer to card issuer's special condition","03":"Invalid merchant","04":"Pick up card","05":"Do not honor","06":"Error","07":"Pick up card, special condition","08":"Honor with identification","09":"Request in progress",10:"Approved for partial amount",11:"Approved (VIP)",12:"Invalid transaction",13:"Invalid amount",14:"Invalid card number",15:"No such issuer",16:"Approved, update track 3",17:"Customer cancellation",18:"Customer dispute",19:"Re-enter transaction",20:"Invalid response",21:"No action taken",22:"Suspected malfunction",23:"Unacceptable transaction fee",24:"File update not supported by receiver",25:"Unable to locate record on file",26:"Duplicate file update record, old record replaced",27:"File update field edit error",28:"File update file locked out",29:"File update not successful, contact acquirer",30:"Format error",31:"Bank not supported by switch",32:"Completed partially",33:"Expired card",34:"Suspected fraud",35:"Card acceptor contact acquirer",36:"Restricted card",37:"Card acceptor call acquirer security",38:"Allowable PIN tries exceeded",39:"No credit account",40:"Requested function not supported",41:"Lost card",42:"No universal account",43:"Stolen card",44:"No investment account",51:"Not sufficient funds",52:"No checking account",53:"No savings account",54:"Expired card",55:"Incorrect PIN",56:"No card record",57:"Transaction not permitted to cardholder",58:"Transaction not permitted to terminal",59:"Suspected fraud",60:"Card acceptor contact acquirer",61:"Exceeds amount limit",62:"Restricted card",63:"Security violation",64:"Original amount incorrect",65:"Exceeds frequency limit",66:"Card acceptor call acquirer's security department",67:"Hard capture (requires that card be picked up at ATM)",68:"Response received too late",75:"Allowable number of PIN tries exceeded",90:"Cutoff is in process",91:"Issuer unavailable",92:"Financial institution or intermediate network facility cannot be found for routing",93:"Transaction cannot be completed, violation of law",94:"Duplicate transmission",95:"Reconcile error",96:"System malfunction",97:"Reserved for national use",98:"Reserved for national use",99:"Reserved for national use"};class Ipay88Error extends Error{constructor(e,r=500,t={}){super(e);this.name="Ipay88Error";this.statusCode=r;this.details=t}}exports.Ipay88Error=Ipay88Error;const generateIpay88Signature=(e,r,t,o,a)=>{const n=`${e}${r}${t}${o}${a}`;return crypto_1.default.createHash("sha256").update(n).digest("hex")};exports.generateIpay88Signature=generateIpay88Signature;const verifyIpay88Signature=(e,r,t,o,a,n,c,s)=>{const i=`${e}${r}${t}${o}${a}${n}${c}`;return crypto_1.default.createHash("sha256").update(i).digest("hex")===s};exports.verifyIpay88Signature=verifyIpay88Signature;const convertToIpay88Amount=e=>Math.round(100*e).toString();exports.convertToIpay88Amount=convertToIpay88Amount;const convertFromIpay88Amount=e=>parseInt(e)/100;exports.convertFromIpay88Amount=convertFromIpay88Amount;