"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),console_1=require("@b/utils/console"),utils_1=require("./utils");exports.metadata={summary:"Creates a PayFast payment session",description:"Initiates a payment with PayFast and returns payment form",operationId:"createPayFastPayment",tags:["Finance","Deposit","PayFast"],requiresAuth:!0,logModule:"PAYFAST_DEPOSIT",logTitle:"Create PayFast payment session",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{amount:{type:"number",description:"Payment amount",minimum:.01},currency:{type:"string",description:"Payment currency code",example:"ZAR"}},required:["amount","currency"]}}}},responses:{200:{description:"Payment session created successfully",content:{"application/json":{schema:{type:"object",properties:{success:{type:"boolean"},data:{type:"object",properties:{transactionId:{type:"string"},reference:{type:"string"},amount:{type:"number"},currency:{type:"string"},paymentUrl:{type:"string"},paymentForm:{type:"string"},redirectUrl:{type:"string"},instructions:{type:"string"},expiresAt:{type:"string"}}}}}}}},400:{description:"Bad request - invalid parameters"},401:{description:"Unauthorized"},500:{description:"Internal server error"}}};exports.default=async e=>{const{body:t,user:r}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Authentication required"});if(!t.amount||!t.currency)throw(0,error_1.createError)({statusCode:400,message:"Amount and currency are required"});(0,utils_1.validatePayFastConfig)();if(!(0,utils_1.isCurrencySupported)(t.currency))throw(0,error_1.createError)({statusCode:400,message:`Currency ${t.currency} is not supported by PayFast`});if(t.amount<=0)throw(0,error_1.createError)({statusCode:400,message:"Amount must be greater than 0"});const{amount:a,currency:s}=t;try{const e=await db_1.models.depositGateway.findOne({where:{id:"payfast"}});if(!e||!e.status)throw(0,error_1.createError)({statusCode:400,message:"PayFast payment gateway is not available"});if(!JSON.parse(e.currencies||"[]").includes(s.toUpperCase()))throw(0,error_1.createError)({statusCode:400,message:`Currency ${s} is not supported`});const t=e.getMinAmount(s),n=e.getMaxAmount(s);if(a<t)throw(0,error_1.createError)({statusCode:400,message:`Minimum amount is ${t} ${s}`});if(null!==n&&a>n)throw(0,error_1.createError)({statusCode:400,message:`Maximum amount is ${n} ${s}`});const i=(0,utils_1.generatePayFastReference)(),o=await db_1.models.transaction.create({uuid:i,userId:r.id,type:"DEPOSIT",status:"PENDING",amount:a,fee:0,description:`PayFast deposit - ${a} ${s}`,metadata:JSON.stringify({gateway:"payfast",currency:s,originalAmount:a,paymentMethod:"payfast"})}),u={merchant_id:utils_1.PAYFAST_CONFIG.MERCHANT_ID,merchant_key:utils_1.PAYFAST_CONFIG.MERCHANT_KEY,return_url:(0,utils_1.buildReturnUrl)(),cancel_url:(0,utils_1.buildCancelUrl)(),notify_url:(0,utils_1.buildNotifyUrl)(),name_first:r.firstName||"Customer",name_last:r.lastName||"",email_address:r.email,m_payment_id:i,amount:(0,utils_1.formatPayFastAmount)(a),item_name:`Wallet Deposit - ${a} ${s}`,item_description:`Deposit to wallet for ${r.email}`,custom_str1:o.id.toString(),custom_str2:r.id.toString(),custom_str3:s,custom_str4:"deposit",custom_str5:"wallet"};utils_1.PAYFAST_CONFIG.PASSPHRASE&&(u.passphrase=utils_1.PAYFAST_CONFIG.PASSPHRASE);u.signature=(0,utils_1.generateSignature)(u,utils_1.PAYFAST_CONFIG.PASSPHRASE);await o.update({metadata:{...o.metadata,payfast:{merchant_id:u.merchant_id,m_payment_id:u.m_payment_id,amount:u.amount,item_name:u.item_name,signature:u.signature,created_at:(new Date).toISOString()}}});return{success:!0,data:{transactionId:o.id,reference:i,amount:a,currency:s,paymentUrl:(0,utils_1.buildPaymentUrl)(),paymentForm:(0,utils_1.generatePaymentForm)(u),paymentData:{...u,merchant_key:void 0,passphrase:void 0},redirectUrl:(0,utils_1.buildPaymentUrl)(),instructions:"You will be redirected to PayFast to complete your payment",expiresAt:new Date(Date.now()+18e5).toISOString()}}}catch(e){console_1.logger.error("PAYFAST","Payment creation error",e);throw(0,error_1.createError)({statusCode:e.statusCode||500,message:e.message||"Failed to create PayFast payment"})}};