"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),utils_1=require("./utils");exports.metadata={summary:"Creates a Paystack payment session",description:"Initializes a payment with Paystack and returns authorization URL for various payment methods across African markets",operationId:"createPaystackPayment",tags:["Finance","Deposit","Paystack"],requiresAuth:!0,logModule:"PAYSTACK_DEPOSIT",logTitle:"Create Paystack payment session",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{amount:{type:"number",description:"Payment amount",minimum:1},currency:{type:"string",description:"Payment currency code",enum:["NGN","GHS","ZAR","KES","XOF","EGP","USD"],example:"NGN"},channels:{type:"array",items:{type:"string"},description:"Preferred payment channels",example:["card","bank","ussd"]},metadata:{type:"object",description:"Additional metadata for the transaction",additionalProperties:!0}},required:["amount","currency"]}}}},responses:{200:{description:"Paystack payment session created successfully",content:{"application/json":{schema:{type:"object",properties:{success:{type:"boolean"},data:{type:"object",properties:{transaction_id:{type:"string"},reference:{type:"string"},authorization_url:{type:"string"},access_code:{type:"string"},status:{type:"string"},gateway:{type:"string"},amount:{type:"number"},currency:{type:"string"},region:{type:"string"},available_methods:{type:"object",additionalProperties:{type:"string"}},supported_channels:{type:"array",items:{type:"string"}},fees_info:{type:"object",properties:{fees:{type:"number"},net_amount:{type:"number"},gross_amount:{type:"number"}}}}}}}}}},400:{description:"Bad request - Invalid parameters",content:{"application/json":{schema:{type:"object",properties:{error:{type:"string"},details:{type:"object"}}}}}},401:{description:"Unauthorized"},404:{description:"Payment gateway not found"},500:{description:"Internal server error"}}};exports.default=async e=>{const{user:t,body:a}=e,{amount:r,currency:s,channels:o,metadata:n={}}=a;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"User not authenticated"});if(!r||r<=0)throw(0,error_1.createError)({statusCode:400,message:"Invalid amount provided"});if(!s)throw(0,error_1.createError)({statusCode:400,message:"Currency is required"});const i=s.toUpperCase();try{(0,utils_1.validatePaystackConfig)();if(!(0,utils_1.isCurrencySupported)(i))throw(0,error_1.createError)({statusCode:400,message:`Currency ${i} is not supported by Paystack. Supported currencies: NGN, GHS, ZAR, KES, XOF, EGP, USD`});const a=await db_1.models.depositGateway.findOne({where:{id:"paystack"}});if(!a||!a.status)throw(0,error_1.createError)({statusCode:400,message:"Paystack payment gateway is not available"});if(!JSON.parse(a.currencies||"[]").includes(i))throw(0,error_1.createError)({statusCode:400,message:`Currency ${i} is not supported by this gateway`});const s=a.getMinAmount(i),c=a.getMaxAmount(i);if(r<s)throw(0,error_1.createError)({statusCode:400,message:`Minimum amount is ${s} ${i}`});if(null!==c&&r>c)throw(0,error_1.createError)({statusCode:400,message:`Maximum amount is ${c} ${i}`});const u=(0,utils_1.generatePaystackReference)(),d=(0,utils_1.getCurrencyInfo)(i),p=(0,utils_1.getAvailablePaymentMethods)(i),m=(0,utils_1.getSupportedChannels)(i),y=(0,utils_1.calculatePaystackFees)(r,i),l={id:u,userId:t.id,type:"DEPOSIT",status:"PENDING",amount:r,currency:i,description:`Paystack deposit - ${r} ${i}`,fee:y.fees,metadata:JSON.stringify({gateway:"paystack",region:null==d?void 0:d.region,available_methods:p,supported_channels:m,user_metadata:n,ip_address:e.remoteAddress})},_=await db_1.models.transaction.create(l),g={reference:u,amount:(0,utils_1.formatPaystackAmount)(r,i),email:t.email||"",currency:i,callback_url:(0,utils_1.buildReturnUrl)(),metadata:{user_id:t.id,transaction_id:_.id,gateway:"paystack",region:null==d?void 0:d.region,original_amount:r,fees:y.fees,net_amount:y.netAmount,...n}};if(o&&Array.isArray(o)&&o.length>0){const e=o.filter(e=>m.includes(e));e.length>0&&(g.channels=e)}else g.channels=m;(t.firstName||t.lastName)&&(g.customer={email:t.email||"",first_name:t.firstName||"",last_name:t.lastName||"",phone:t.phone||"",metadata:{user_id:t.id}});const f=await(0,utils_1.makePaystackRequest)("/transaction/initialize",{method:"POST",body:g});if(!f.status||!f.data)throw(0,error_1.createError)({statusCode:400,message:f.message||"Failed to initialize Paystack transaction"});await _.update({referenceId:f.data.reference,metadata:JSON.stringify({...JSON.parse(_.metadata||"{}"),paystack_access_code:f.data.access_code,paystack_reference:f.data.reference,authorization_url:f.data.authorization_url})});const h=p.reduce((e,t)=>{e[t]=(0,utils_1.getPaymentMethodDisplayName)(t);return e},{});return{success:!0,data:{transaction_id:_.id,reference:u,authorization_url:f.data.authorization_url,access_code:f.data.access_code,status:"PENDING",gateway:"paystack",amount:r,currency:i,region:(null==d?void 0:d.region)||"Africa",available_methods:h,supported_channels:m,fees_info:{fees:y.fees,net_amount:y.netAmount,gross_amount:y.grossAmount}}}}catch(e){if(e instanceof utils_1.PaystackError)throw(0,error_1.createError)({statusCode:e.status,message:e.message});if(e.statusCode)throw e;throw(0,error_1.createError)({statusCode:500,message:"Failed to create Paystack payment session"})}};