"use strict";function validatePayUConfig(){if(!exports.PAYU_CONFIG.MERCHANT_KEY)throw(0,error_1.createError)({statusCode:500,message:"PayU merchant key not configured"});if(!exports.PAYU_CONFIG.MERCHANT_SALT)throw(0,error_1.createError)({statusCode:500,message:"PayU merchant salt not configured"});if(!exports.PAYU_CONFIG.MERCHANT_ID)throw(0,error_1.createError)({statusCode:500,message:"PayU merchant ID not configured"})}function validatePayUCurrency(e){return e in exports.PAYU_SUPPORTED_CURRENCIES}function getPayUCurrencyInfo(e){const t=exports.PAYU_SUPPORTED_CURRENCIES[e];if(!t)throw(0,error_1.createError)({statusCode:400,message:`Unsupported currency: ${e}`});return t}function generatePayUHash(e,t){const r=`${e.key}|${e.txnid}|${e.amount}|${e.productinfo}|${e.firstname}|${e.email}|${e.udf1||""}|${e.udf2||""}|${e.udf3||""}|${e.udf4||""}|${e.udf5||""}||||||${t}`;return crypto.createHash("sha512").update(r).digest("hex")}function verifyPayUHash(e,t,r){const a=`${r}|${e.status}||||||${e.udf5||""}|${e.udf4||""}|${e.udf3||""}|${e.udf2||""}|${e.udf1||""}|${e.email}|${e.firstname}|${e.productinfo}|${e.amount}|${e.txnid}|${e.key}`;return crypto.createHash("sha512").update(a).digest("hex")===t}async function makePayURequest(e,t){const r=`${exports.PAYU_CONFIG.API_BASE_URL}${e}`;try{const e=await fetch(r,{method:t.method,headers:{"Content-Type":"application/x-www-form-urlencoded","User-Agent":"PayU-NodeJS-SDK/1.0.0",...t.headers},body:t.body?new URLSearchParams(t.body).toString():void 0});if(!e.ok)throw(0,error_1.createError)({statusCode:e.status,message:`PayU API error: ${e.statusText}`});return await e.json()}catch(e){if(e instanceof Error)throw(0,error_1.createError)({statusCode:500,message:`PayU API request failed: ${e.message}`});throw e}}function mapPayUStatus(e){const t=e.toLowerCase();return exports.PAYU_STATUS_MAPPING[t]||"PENDING"}function parsePayUAmount(e){const t=parseFloat(e);if(isNaN(t))throw(0,error_1.createError)({statusCode:400,message:"Invalid amount format"});return t}function getPayUPaymentMethods(e){return getPayUCurrencyInfo(e).methods}function generatePayUTransactionId(){return`payu_${Date.now()}_${Math.random().toString(36).substr(2,9)}`}function formatPayUAmount(e){return e.toFixed(2)}function validatePaymentMethod(e,t){return getPayUPaymentMethods(e).includes(t)}function getPaymentMethodFees(e,t){const r=getPayUCurrencyInfo(e),a=t.toLowerCase().replace(/[-\s]/g,"_");return r.fees[a]||r.fees.international}function calculatePayUFees(e,t,r){const a=getPaymentMethodFees(t,r),n=e*a.percentage/100,i=n+a.fixed;return{amount:e,percentageFee:n,fixedFee:a.fixed,totalFee:i,netAmount:e-i}}var __createBinding=this&&this.__createBinding||(Object.create?function(e,t,r,a){void 0===a&&(a=r);var n=Object.getOwnPropertyDescriptor(t,r);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[r]}});Object.defineProperty(e,a,n)}:function(e,t,r,a){void 0===a&&(a=r);e[a]=t[r]}),__setModuleDefault=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),__importStar=this&&this.__importStar||function(){var e=function(t){e=Object.getOwnPropertyNames||function(e){var t=[];for(var r in e)Object.prototype.hasOwnProperty.call(e,r)&&(t[t.length]=r);return t};return e(t)};return function(t){if(t&&t.__esModule)return t;var r={};if(null!=t)for(var a=e(t),n=0;n<a.length;n++)"default"!==a[n]&&__createBinding(r,t,a[n]);__setModuleDefault(r,t);return r}}();Object.defineProperty(exports,"__esModule",{value:!0});exports.PAYU_WEBHOOK_EVENTS=exports.PAYU_STATUS_MAPPING=exports.PAYU_SUPPORTED_CURRENCIES=exports.PAYU_CONFIG=void 0;exports.validatePayUConfig=validatePayUConfig;exports.validatePayUCurrency=validatePayUCurrency;exports.getPayUCurrencyInfo=getPayUCurrencyInfo;exports.generatePayUHash=generatePayUHash;exports.verifyPayUHash=verifyPayUHash;exports.makePayURequest=makePayURequest;exports.mapPayUStatus=mapPayUStatus;exports.parsePayUAmount=parsePayUAmount;exports.getPayUPaymentMethods=getPayUPaymentMethods;exports.generatePayUTransactionId=generatePayUTransactionId;exports.formatPayUAmount=formatPayUAmount;exports.validatePaymentMethod=validatePaymentMethod;exports.getPaymentMethodFees=getPaymentMethodFees;exports.calculatePayUFees=calculatePayUFees;const error_1=require("@b/utils/error"),crypto=__importStar(require("crypto"));exports.PAYU_CONFIG={API_BASE_URL:"true"===process.env.APP_PAYU_SANDBOX?"https://test.payu.in":"https://secure.payu.in",MERCHANT_KEY:process.env.APP_PAYU_MERCHANT_KEY||"",MERCHANT_SALT:process.env.APP_PAYU_MERCHANT_SALT||"",MERCHANT_ID:process.env.APP_PAYU_MERCHANT_ID||"",SANDBOX:"true"===process.env.APP_PAYU_SANDBOX,CALLBACK_URL:process.env.APP_PAYU_CALLBACK_URL||"/user/wallet/deposit/payu/verify",WEBHOOK_ENDPOINT:process.env.APP_PAYU_WEBHOOK_ENDPOINT||"/api/finance/deposit/fiat/payu/webhook",SUCCESS_URL:process.env.APP_PAYU_SUCCESS_URL||"/user/wallet/deposit/payu/success",FAILURE_URL:process.env.APP_PAYU_FAILURE_URL||"/user/wallet/deposit/payu/failure",CANCEL_URL:process.env.APP_PAYU_CANCEL_URL||"/user/wallet/deposit/payu/cancel",VERSION:"1.0"};exports.PAYU_SUPPORTED_CURRENCIES={INR:{region:"India",country:"IN",methods:["card","upi","netbanking","wallet","emi","cash"],fees:{upi:{percentage:0,fixed:0},debit_cards:{percentage:.9,fixed:0},credit_cards:{percentage:1.9,fixed:0},net_banking:{percentage:1.2,fixed:0},wallet:{percentage:1.5,fixed:0},emi:{percentage:2.5,fixed:0},international:{percentage:3.5,fixed:0}}},USD:{region:"United States",country:"US",methods:["card"],fees:{upi:{percentage:0,fixed:0},debit_cards:{percentage:3.5,fixed:0},credit_cards:{percentage:3.5,fixed:0},net_banking:{percentage:0,fixed:0},wallet:{percentage:0,fixed:0},emi:{percentage:0,fixed:0},international:{percentage:3.5,fixed:0}}},EUR:{region:"Europe",country:"EU",methods:["card"],fees:{upi:{percentage:0,fixed:0},debit_cards:{percentage:2.8,fixed:0},credit_cards:{percentage:2.8,fixed:0},net_banking:{percentage:0,fixed:0},wallet:{percentage:0,fixed:0},emi:{percentage:0,fixed:0},international:{percentage:2.8,fixed:0}}},GBP:{region:"United Kingdom",country:"GB",methods:["card"],fees:{upi:{percentage:0,fixed:0},debit_cards:{percentage:2.9,fixed:0},credit_cards:{percentage:2.9,fixed:0},net_banking:{percentage:0,fixed:0},wallet:{percentage:0,fixed:0},emi:{percentage:0,fixed:0},international:{percentage:2.9,fixed:0}}},PLN:{region:"Poland",country:"PL",methods:["card","bank_transfer"],fees:{upi:{percentage:0,fixed:0},debit_cards:{percentage:2.5,fixed:0},credit_cards:{percentage:2.5,fixed:0},net_banking:{percentage:2,fixed:0},wallet:{percentage:0,fixed:0},emi:{percentage:0,fixed:0},international:{percentage:2.5,fixed:0}}},CZK:{region:"Czech Republic",country:"CZ",methods:["card","bank_transfer"],fees:{upi:{percentage:0,fixed:0},debit_cards:{percentage:2.7,fixed:0},credit_cards:{percentage:2.7,fixed:0},net_banking:{percentage:2.2,fixed:0},wallet:{percentage:0,fixed:0},emi:{percentage:0,fixed:0},international:{percentage:2.7,fixed:0}}},RON:{region:"Romania",country:"RO",methods:["card","bank_transfer"],fees:{upi:{percentage:0,fixed:0},debit_cards:{percentage:2.6,fixed:0},credit_cards:{percentage:2.6,fixed:0},net_banking:{percentage:2.1,fixed:0},wallet:{percentage:0,fixed:0},emi:{percentage:0,fixed:0},international:{percentage:2.6,fixed:0}}},HUF:{region:"Hungary",country:"HU",methods:["card","bank_transfer"],fees:{upi:{percentage:0,fixed:0},debit_cards:{percentage:2.8,fixed:0},credit_cards:{percentage:2.8,fixed:0},net_banking:{percentage:2.3,fixed:0},wallet:{percentage:0,fixed:0},emi:{percentage:0,fixed:0},international:{percentage:2.8,fixed:0}}},UAH:{region:"Ukraine",country:"UA",methods:["card","bank_transfer"],fees:{upi:{percentage:0,fixed:0},debit_cards:{percentage:3.2,fixed:0},credit_cards:{percentage:3.2,fixed:0},net_banking:{percentage:2.7,fixed:0},wallet:{percentage:0,fixed:0},emi:{percentage:0,fixed:0},international:{percentage:3.2,fixed:0}}},TRY:{region:"Turkey",country:"TR",methods:["card","bank_transfer"],fees:{upi:{percentage:0,fixed:0},debit_cards:{percentage:3,fixed:0},credit_cards:{percentage:3,fixed:0},net_banking:{percentage:2.5,fixed:0},wallet:{percentage:0,fixed:0},emi:{percentage:0,fixed:0},international:{percentage:3,fixed:0}}},BRL:{region:"Brazil",country:"BR",methods:["card","boleto","pix"],fees:{upi:{percentage:0,fixed:0},debit_cards:{percentage:3.8,fixed:0},credit_cards:{percentage:3.8,fixed:0},net_banking:{percentage:3.3,fixed:0},wallet:{percentage:0,fixed:0},emi:{percentage:0,fixed:0},international:{percentage:3.8,fixed:0}}},COP:{region:"Colombia",country:"CO",methods:["card","bank_transfer","cash"],fees:{upi:{percentage:0,fixed:0},debit_cards:{percentage:3.5,fixed:0},credit_cards:{percentage:3.5,fixed:0},net_banking:{percentage:3,fixed:0},wallet:{percentage:0,fixed:0},emi:{percentage:0,fixed:0},international:{percentage:3.5,fixed:0}}},PEN:{region:"Peru",country:"PE",methods:["card","bank_transfer","cash"],fees:{upi:{percentage:0,fixed:0},debit_cards:{percentage:3.3,fixed:0},credit_cards:{percentage:3.3,fixed:0},net_banking:{percentage:2.8,fixed:0},wallet:{percentage:0,fixed:0},emi:{percentage:0,fixed:0},international:{percentage:3.3,fixed:0}}},ARS:{region:"Argentina",country:"AR",methods:["card","bank_transfer","cash"],fees:{upi:{percentage:0,fixed:0},debit_cards:{percentage:4.2,fixed:0},credit_cards:{percentage:4.2,fixed:0},net_banking:{percentage:3.7,fixed:0},wallet:{percentage:0,fixed:0},emi:{percentage:0,fixed:0},international:{percentage:4.2,fixed:0}}},CLP:{region:"Chile",country:"CL",methods:["card","bank_transfer"],fees:{upi:{percentage:0,fixed:0},debit_cards:{percentage:3.7,fixed:0},credit_cards:{percentage:3.7,fixed:0},net_banking:{percentage:3.2,fixed:0},wallet:{percentage:0,fixed:0},emi:{percentage:0,fixed:0},international:{percentage:3.7,fixed:0}}},MXN:{region:"Mexico",country:"MX",methods:["card","bank_transfer","cash"],fees:{upi:{percentage:0,fixed:0},debit_cards:{percentage:3.4,fixed:0},credit_cards:{percentage:3.4,fixed:0},net_banking:{percentage:2.9,fixed:0},wallet:{percentage:0,fixed:0},emi:{percentage:0,fixed:0},international:{percentage:3.4,fixed:0}}},ZAR:{region:"South Africa",country:"ZA",methods:["card","bank_transfer"],fees:{upi:{percentage:0,fixed:0},debit_cards:{percentage:2.9,fixed:0},credit_cards:{percentage:2.9,fixed:0},net_banking:{percentage:2.4,fixed:0},wallet:{percentage:0,fixed:0},emi:{percentage:0,fixed:0},international:{percentage:2.9,fixed:0}}}};exports.PAYU_STATUS_MAPPING={success:"COMPLETED",failure:"FAILED",pending:"PENDING",cancel:"CANCELLED",in_progress:"PENDING",dropped:"FAILED",bounced:"FAILED",timeout:"FAILED",initiated:"PENDING",awaited:"PENDING",auth:"PENDING",captured:"COMPLETED",void:"CANCELLED",refunded:"REFUNDED"};exports.PAYU_WEBHOOK_EVENTS={PAYMENT_SUCCESS:"payment_success",PAYMENT_FAILED:"payment_failed",PAYMENT_PENDING:"payment_pending",REFUND_SUCCESS:"refund_success",REFUND_FAILED:"refund_failed"};