"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),emails_1=require("@b/utils/emails"),utils_1=require("./utils"),wallet_1=require("@b/services/wallet");exports.metadata={summary:"Handles PayU webhook notifications",description:"Processes real-time payment notifications from PayU with hash verification and status updates",operationId:"payuWebhook",tags:["Finance","Deposit","PayU","Webhook"],logModule:"WEBHOOK",logTitle:"PayU webhook",requiresAuth:!1,requestBody:{required:!0,content:{"application/x-www-form-urlencoded":{schema:{type:"object",properties:{mihpayid:{type:"string"},mode:{type:"string"},status:{type:"string"},unmappedstatus:{type:"string"},key:{type:"string"},txnid:{type:"string"},amount:{type:"string"},addedon:{type:"string"},productinfo:{type:"string"},firstname:{type:"string"},lastname:{type:"string"},address1:{type:"string"},address2:{type:"string"},city:{type:"string"},state:{type:"string"},country:{type:"string"},zipcode:{type:"string"},email:{type:"string"},phone:{type:"string"},udf1:{type:"string"},udf2:{type:"string"},udf3:{type:"string"},udf4:{type:"string"},udf5:{type:"string"},udf6:{type:"string"},udf7:{type:"string"},udf8:{type:"string"},udf9:{type:"string"},udf10:{type:"string"},hash:{type:"string"},field1:{type:"string"},field2:{type:"string"},field3:{type:"string"},field4:{type:"string"},field5:{type:"string"},field6:{type:"string"},field7:{type:"string"},field8:{type:"string"},field9:{type:"string"},payment_source:{type:"string"},PG_TYPE:{type:"string"},bank_ref_num:{type:"string"},bankcode:{type:"string"},error:{type:"string"},error_Message:{type:"string"},name_on_card:{type:"string"},cardnum:{type:"string"},cardhash:{type:"string"},amount_split:{type:"string"},payuMoneyId:{type:"string"},discount:{type:"string"},net_amount_debit:{type:"string"},card_token:{type:"string"}},required:["txnid","key","status","hash"]}}}},responses:{200:{description:"Webhook processed successfully",content:{"application/json":{schema:{type:"object",properties:{success:{type:"boolean"},message:{type:"string"}}}}}},400:{description:"Bad request - Invalid webhook data"},401:{description:"Unauthorized - Invalid webhook signature"},404:{description:"Transaction not found"},500:{description:"Internal server error"}}};exports.default=async e=>{const{body:t,headers:r}=e,s=t;try{(0,utils_1.validatePayUConfig)();if(!(s.txnid&&s.key&&s.status&&s.hash))throw(0,error_1.createError)({statusCode:400,message:"Missing required webhook fields"});if(s.key!==utils_1.PAYU_CONFIG.MERCHANT_KEY)throw(0,error_1.createError)({statusCode:400,message:"Invalid merchant key"});const e={key:s.key,txnid:s.txnid,amount:s.amount,productinfo:s.productinfo,firstname:s.firstname,email:s.email,status:s.status,udf1:s.udf1||"",udf2:s.udf2||"",udf3:s.udf3||"",udf4:s.udf4||"",udf5:s.udf5||""};if(!(0,utils_1.verifyPayUHash)(e,s.hash,utils_1.PAYU_CONFIG.MERCHANT_SALT))throw(0,error_1.createError)({statusCode:401,message:"Invalid webhook signature"});const t=await db_1.models.transaction.findOne({where:{uuid:s.txnid,type:"DEPOSIT"},include:[{model:db_1.models.user,as:"user"}]});if(!t)throw(0,error_1.createError)({statusCode:404,message:"Transaction not found"});const r=t.user;if(!r)throw(0,error_1.createError)({statusCode:404,message:"User not found for transaction"});const a=JSON.parse(t.metadata||"{}");if("payu"!==a.gateway)throw(0,error_1.createError)({statusCode:400,message:"Invalid gateway for this transaction"});const i=(0,utils_1.mapPayUStatus)(s.status),n=(0,utils_1.parsePayUAmount)(s.amount||"0",a.currency||"INR");if(t.status===i)return{success:!0,message:"Webhook processed - no status change"};const o=await db_1.sequelize.transaction();try{await t.update({status:i,referenceId:s.mihpayid||t.referenceId,metadata:JSON.stringify({...a,mihpayid:s.mihpayid,bankRefNum:s.bank_ref_num,paymentMode:s.mode,bankCode:s.bankcode,paymentSource:s.payment_source,pgType:s.PG_TYPE,nameOnCard:s.name_on_card,cardNum:s.cardnum,cardHash:s.cardhash,payuMoneyId:s.payuMoneyId,discount:s.discount,netAmountDebit:s.net_amount_debit,cardToken:s.card_token,error:s.error,errorMessage:s.error_Message,addedOn:s.addedon,webhookProcessedAt:(new Date).toISOString()})},{transaction:o});if("COMPLETED"===i){const e=a.currency||"USD";let i=await db_1.models.wallet.findOne({where:{userId:r.id,currency:e,type:"FIAT"},transaction:o});i||(i=await wallet_1.walletCreationService.getOrCreateWallet(r.id,"FIAT",e,o));const d=`payu_webhook_${s.txnid}`;await wallet_1.walletService.credit({idempotencyKey:d,userId:r.id,walletId:i.id,walletType:"FIAT",currency:e,amount:n,operationType:"DEPOSIT",referenceId:s.txnid,description:`PayU deposit - ${n} ${e}`,metadata:{method:"PAYU",mihpayid:s.mihpayid,paymentMode:s.mode},transaction:o});const u=parseFloat(i.balance)+n;await(0,emails_1.sendFiatTransactionEmail)(r,t,e,u)}await o.commit();return{success:!0,message:"Webhook processed successfully",data:{transaction_id:s.txnid,status:i,mihpayid:s.mihpayid,amount:n,currency:a.currency||"INR",payment_mode:s.mode,processed_at:(new Date).toISOString()}}}catch(e){await o.rollback();throw e}}catch(e){if(e.statusCode)throw e;throw(0,error_1.createError)({statusCode:500,message:e instanceof Error?e.message:"Webhook processing failed"})}};