"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),error_1=require("@b/utils/error"),utils_1=require("./utils"),db_1=require("@b/db"),publicUrl=process.env.NEXT_PUBLIC_SITE_URL,isProduction="production"===process.env.NODE_ENV;exports.metadata={summary:"Creates a Stripe payment intent or checkout session",description:"Initiates a Stripe payment process by creating either a payment intent or a checkout session, based on the request parameters. This endpoint supports different workflows for web and Flutter applications.",operationId:"createStripePayment",tags:["Finance","Deposit"],logModule:"STRIPE_DEPOSIT",logTitle:"Create Stripe payment",requestBody:{description:"Payment information and application type",content:{"application/json":{schema:{type:"object",properties:{amount:{type:"number",description:"Payment amount in smallest currency unit (e.g., cents)"},currency:{type:"string",description:"Currency code (e.g., USD)"},intent:{type:"boolean",description:"Flag indicating if the request is from a mobile app",nullable:!0}},required:["amount","currency"]}}}},responses:{200:{description:"Payment intent or checkout session created successfully. The response structure varies based on the request context: for Flutter applications, `id` and `clientSecret` are returned; for web applications, `version`, `id`, and `url` are provided.",content:{"application/json":{schema:{type:"object",properties:{id:{type:"string",description:"Payment intent or session ID"},clientSecret:{type:"string",description:"Client secret for payment intent",nullable:!0},version:{type:"string",description:"Stripe API version",nullable:!0},url:{type:"string",description:"Checkout session URL",nullable:!0}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Stripe"),500:query_1.serverErrorResponse},requiresAuth:!0};exports.default=async e=>{var t;const{user:r,body:s,ctx:n}=e;if(!r)throw(0,error_1.createError)({statusCode:401,message:"User not authenticated"});const{amount:i,currency:o,intent:a}=s,c=100*i;null==n||n.step("Fetching payment gateway configuration");const u=await db_1.models.depositGateway.findOne({where:{alias:"stripe",status:!0}});if(!u)throw(0,error_1.createError)({statusCode:404,message:"Stripe gateway not found"});if(!(null===(t=u.currencies)||void 0===t?void 0:t.includes(o)))throw(0,error_1.createError)({statusCode:400,message:`Currency ${o} is not supported by Stripe`});null==n||n.step("Calculating fees");const p=u.getFixedFee(o),l=100*(i*u.getPercentageFee(o)/100+p),d=(0,utils_1.useStripe)();if(a){const e=c+l;try{const t=await d.paymentIntents.create({amount:e,currency:o});null==n||n.success("Stripe payment intent created successfully");return{id:t.id,clientSecret:t.client_secret}}catch(e){throw(0,error_1.createError)({statusCode:500,message:`Error creating payment intent: ${e.message}`})}}try{const e=await d.checkout.sessions.create({payment_method_types:["card"],line_items:[{price_data:{currency:o,product_data:{name:"Deposit"},unit_amount:c},quantity:1},{price_data:{currency:o,product_data:{name:"Tax"},unit_amount:l},quantity:1}],mode:"payment",success_url:`${publicUrl}${isProduction?"":":3000"}/stripe-popup-success.html?sessionId={CHECKOUT_SESSION_ID}`,cancel_url:`${publicUrl}${isProduction?"":":3000"}/stripe-popup-cancel.html`});null==n||n.success("Stripe checkout session created successfully");return{version:d.VERSION,id:e.id,url:e.url}}catch(e){throw(0,error_1.createError)({statusCode:500,message:`Error creating checkout session: ${e.message}`})}};