"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),error_1=require("@b/utils/error"),utils_1=require("./utils"),db_1=require("@b/db"),emails_1=require("@b/utils/emails"),console_1=require("@b/utils/console"),utils_2=require("@b/api/finance/utils");exports.metadata={summary:"Verifies a Stripe checkout session",description:"Confirms the validity of a Stripe checkout session by its session ID, ensuring the session is authenticated and retrieving associated payment intent and line items details.",operationId:"verifyStripeCheckoutSession",tags:["Finance","Deposit"],requiresAuth:!0,logModule:"STRIPE_DEPOSIT",logTitle:"Verify Stripe checkout session",parameters:[{index:0,name:"sessionId",in:"query",description:"Stripe checkout session ID",required:!0,schema:{type:"string"}}],responses:{200:{description:"Checkout session verified successfully. Returns the session ID, payment intent status, and detailed line items.",content:{"application/json":{schema:{type:"object",properties:{id:{type:"string",description:"Session ID"},status:{type:"string",description:"Payment intent status",nullable:!0},lineItems:{type:"array",items:{type:"object",properties:{id:{type:"string",description:"Line item ID"},description:{type:"string",description:"Line item description"},amountSubtotal:{type:"number",description:"Subtotal amount"},amountTotal:{type:"number",description:"Total amount"},currency:{type:"string",description:"Currency code"}}},description:"List of line items associated with the checkout session"}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Stripe"),500:query_1.serverErrorResponse}};exports.default=async e=>{var t;const{user:s,query:r,ctx:i}=e;if(!s)throw(0,error_1.createError)({statusCode:401,message:"User not authenticated"});const{sessionId:n}=r,o=(0,utils_1.useStripe)();try{null==i||i.step("Retrieving Stripe checkout session");const e=(await o.checkout.sessions.retrieve(n)).payment_intent,r=e?await o.paymentIntents.retrieve(e):null,a=(await o.checkout.sessions.listLineItems(n)).data.map(e=>({id:e.id,description:e.description,currency:e.currency,amount:e.amount_subtotal/100})),c=r?r.status:"unknown";if("canceled"===c)throw(0,error_1.createError)({statusCode:400,message:"Payment was canceled by the user"});if("requires_payment_method"===c||"requires_confirmation"===c)throw(0,error_1.createError)({statusCode:400,message:"Payment was not completed"});if("succeeded"!==c){null==i||i.fail("Payment not succeeded");throw(0,error_1.createError)({statusCode:400,message:`Payment intent not succeeded. Status: ${c}`})}if("succeeded"===c){null==i||i.step("Fetching user account");const e=await db_1.models.user.findByPk(s.id);if(!e){null==i||i.fail("User not found");throw(0,error_1.createError)({statusCode:404,message:"User not found"})}null==i||i.step("Checking for duplicate transaction");if(await db_1.models.transaction.findOne({where:{referenceId:n}}))throw(0,error_1.createError)({statusCode:409,message:"Transaction already exists"});const{currency:r,amount:o}=a[0],c=(null===(t=a[1])||void 0===t?void 0:t.amount)||0,u=await(0,utils_2.processFiatDeposit)({userId:s.id,currency:r,amount:o,fee:c,referenceId:n,method:"STRIPE",description:`Deposit of ${o} ${r} to ${null==e?void 0:e.firstName} ${null==e?void 0:e.lastName} wallet by Stripe.`,idempotencyKey:`stripe_deposit_${n}`,ctx:i}),d=await db_1.models.transaction.findByPk(u.transactionId);try{null==i||i.step("Sending notification email");await(0,emails_1.sendFiatTransactionEmail)(e,d,r,u.newBalance)}catch(e){console_1.logger.error("STRIPE","Error sending email",e)}null==i||i.success("Stripe deposit completed successfully");return{transaction:d,balance:u.newBalance,currency:r,method:"Stripe"}}}catch(e){throw(0,error_1.createError)({statusCode:500,message:`Error retrieving session and line items: ${e.message}`})}};