"use strict";function startSpotVerificationSchedule(e,t,o){const r={trx:o},n=exports.spotVerificationIntervals.get(e);n&&clearInterval(n);const a=setInterval(async()=>{try{await verifyTransaction(t,o,r)}catch(t){console_1.logger.error("SPOT_DEPOSIT",`Error verifying transaction: ${t.message}`);stopVerificationSchedule(e)}},15e3);exports.spotVerificationIntervals.set(e,a);setTimeout(()=>{stopVerificationSchedule(e)},18e5)}function stopVerificationSchedule(e){const t=exports.spotVerificationIntervals.get(e);if(t){clearInterval(t);exports.spotVerificationIntervals.delete(e)}}function isValidJSON(e){try{JSON.parse(e);return!0}catch(e){return!1}}function unescapeString(e){return e.replace(/\\"/g,'"').replace(/\\\\/g,"\\")}async function verifyTransaction(e,t,o){var r;console_1.logger.debug("SPOT_DEPOSIT",`Starting verification for transaction ${t} (User: ${e})`);try{const n=await getTransactionQuery(e,t);if(!n){console_1.logger.error("SPOT_DEPOSIT",`Transaction not found for trx: ${t}, userId: ${e}`);throw(0,error_1.createError)({statusCode:404,message:"Transaction not found"})}const a=await db_1.models.wallet.findByPk(n.walletId);if(!a){console_1.logger.error("SPOT_DEPOSIT",`Wallet not found for transaction ${n.id}`);throw(0,error_1.createError)({statusCode:404,message:"Wallet not found"})}console_1.logger.debug("SPOT_DEPOSIT",`Processing transaction ${n.id} for currency ${a.currency}`);const{metadata:s,xtChain:i}=(0,utils_3.parseMetadataAndMapChainToXt)(n.metadata);console_1.logger.debug("SPOT_DEPOSIT",`Chain: ${s.chain}, XT mapped chain: ${i}`);if("COMPLETED"===n.status){console_1.logger.debug("SPOT_DEPOSIT",`Transaction ${n.id} already completed`);sendMessage(o,{status:201,message:"Transaction already completed",transaction:n,balance:a.balance,currency:a.currency,chain:s.chain,method:"Wallet Transfer"});stopVerificationSchedule(n.id);return}console_1.logger.debug("SPOT_DEPOSIT","Initializing exchange connection...");const c=await exchange_1.default.startExchange();if(!c){console_1.logger.error("SPOT_DEPOSIT","Exchange instance not available - this could indicate missing exchange configuration");const O=await db_1.models.exchange.findOne({where:{status:!0}});if(!O){console_1.logger.error("SPOT_DEPOSIT","No active exchange provider found in database");sendMessage(o,{status:500,message:"No exchange provider configured. Please configure an exchange provider in the admin panel."});stopVerificationSchedule(n.id);return}console_1.logger.error("SPOT_DEPOSIT",`Exchange provider '${O.name}' is configured but connection failed`);sendMessage(o,{status:500,message:`Exchange connection failed. Please check ${O.name} API credentials.`});stopVerificationSchedule(n.id);return}const l=await exchange_1.default.getProvider();if(!l){console_1.logger.error("SPOT_DEPOSIT","Provider name not available");sendMessage(o,{status:500,message:"Exchange provider not available"});stopVerificationSchedule(n.id);return}console_1.logger.debug("SPOT_DEPOSIT",`Using exchange provider: ${l}`);try{const m=await exchange_1.default.testExchangeCredentials(l);if(!m.status){console_1.logger.error("SPOT_DEPOSIT",`Exchange credentials test failed: ${m.message}`);sendMessage(o,{status:500,message:`Exchange credentials invalid: ${m.message}`});stopVerificationSchedule(n.id);return}console_1.logger.debug("SPOT_DEPOSIT","Exchange credentials verified successfully")}catch(E){console_1.logger.error("SPOT_DEPOSIT",`Error testing exchange credentials: ${E.message}`)}console_1.logger.debug("SPOT_DEPOSIT",`Fetching deposits for currency ${a.currency}...`);let d,u=[];try{if(c.has.fetchDeposits){const I={};if(i&&"xt"===l){I.chain=i;console_1.logger.debug("SPOT_DEPOSIT",`Using XT chain parameter: ${i}`)}else if("kucoin"===l&&s.chain){const D={TRC20:"TRX",ERC20:"ETH",BEP20:"BSC",POLYGON:"MATIC",ARBITRUM:"ARBITRUM",OPTIMISM:"OPTIMISM"}[s.chain]||s.chain;I.chain=D;console_1.logger.debug("SPOT_DEPOSIT",`Using KuCoin chain parameter: ${D} (original: ${s.chain})`)}if("kucoin"===l){console_1.logger.debug("SPOT_DEPOSIT","KuCoin Debug - Testing different parameter combinations...");console_1.logger.debug("SPOT_DEPOSIT","KuCoin Try #1: With chain='TRX' parameter");u=await c.fetchDeposits(a.currency,void 0,void 0,I);console_1.logger.debug("SPOT_DEPOSIT",`KuCoin Try #1 Result: ${u.length} deposits`);if(0===u.length){console_1.logger.debug("SPOT_DEPOSIT","KuCoin Try #2: Without chain parameter");const b=await c.fetchDeposits(a.currency);console_1.logger.debug("SPOT_DEPOSIT",`KuCoin Try #2 Result: ${b.length} deposits`);if(b.length>0){u=b;console_1.logger.debug("SPOT_DEPOSIT","KuCoin: Using results from Try #2 (no chain parameter)")}}if(0===u.length){console_1.logger.debug("SPOT_DEPOSIT","KuCoin Try #3: Fetching ALL deposits (no currency filter)");try{const y=await c.fetchDeposits();console_1.logger.debug("SPOT_DEPOSIT",`KuCoin Try #3 Result: ${y.length} total deposits`);if(y.length>0){const $=y.filter(e=>"TRX"===e.currency);console_1.logger.debug("SPOT_DEPOSIT",`KuCoin Try #3: Found ${$.length} TRX deposits out of ${y.length} total`);if($.length>0){u=$;console_1.logger.debug("SPOT_DEPOSIT","KuCoin: Using filtered TRX deposits")}}}catch(w){console_1.logger.error("SPOT_DEPOSIT",`KuCoin Try #3 Error: ${w.message}`)}}}else u=await c.fetchDeposits(a.currency,void 0,void 0,I);console_1.logger.debug("SPOT_DEPOSIT",`Found ${u.length} deposits using fetchDeposits`);u.length>0?console_1.logger.debug("SPOT_DEPOSIT",`Sample: ${u.slice(0,3).map(e=>`${e.currency}:${e.amount}`).join(", ")}`):console_1.logger.debug("SPOT_DEPOSIT","No deposits found - deposit may not have arrived yet")}else{if(!c.has.fetchTransactions){console_1.logger.error("SPOT_DEPOSIT",`Exchange ${l} does not support fetchDeposits or fetchTransactions`);sendMessage(o,{status:500,message:`Exchange ${l} does not support deposit verification`});stopVerificationSchedule(n.id);return}u=await c.fetchTransactions();console_1.logger.debug("SPOT_DEPOSIT",`Found ${u.length} transactions using fetchTransactions`)}}catch(x){console_1.logger.error("SPOT_DEPOSIT",`Error fetching deposits or transactions: ${x.message}`);if("AuthenticationError"===x.name||"PermissionDenied"===x.name){sendMessage(o,{status:500,message:`Exchange authentication failed: ${x.message}`});stopVerificationSchedule(n.id);return}return}console_1.logger.debug("SPOT_DEPOSIT",`Searching for transaction ${t} in ${u.length} deposits...`);d="binance"===l?u.find(e=>{const t=p(e.txid)===n.referenceId;t&&console_1.logger.debug("SPOT_DEPOSIT",`Found matching Binance deposit: ${e.txid}`);return t}):u.find(e=>{const t=e.txid===n.referenceId;t&&console_1.logger.debug("SPOT_DEPOSIT",`Found matching deposit: ${e.txid}`);return t});if(!d){console_1.logger.debug("SPOT_DEPOSIT",`Transaction ${t} not found in exchange deposits yet`);return}console_1.logger.debug("SPOT_DEPOSIT",`Found deposit with status: ${d.status}, amount: ${d.amount}`);if("ok"!==d.status){console_1.logger.debug("SPOT_DEPOSIT",`Deposit status is not 'ok': ${d.status}`);return}const g=d.amount,f=(null===(r=d.fee)||void 0===r?void 0:r.cost)||0;console_1.logger.debug("SPOT_DEPOSIT",`Processing deposit: amount=${g}, fee=${f}, currency=${d.currency||a.currency}`);if(["kucoin","binance","okx","xt"].includes(l)&&a.currency!==d.currency){console_1.logger.error("SPOT_DEPOSIT",`Currency mismatch: wallet=${a.currency}, deposit=${d.currency}`);sendMessage(o,{status:400,message:"Invalid deposit currency"});stopVerificationSchedule(n.id);await deleteTransaction(n.id);return}const T=cache_1.CacheManager.getInstance(),_=await T.getSettings();if(_.has("depositExpiration")&&"true"===_.get("depositExpiration")){const v=d.timestamp/1e3,C=n.createdAt?new Date(n.createdAt).getTime()/1e3:0,M=(Date.now()/1e3-v)/60;if(v<C-900||v>C+900||M>45){console_1.logger.warn("SPOT_DEPOSIT",`Deposit expired: timeDiff=${M.toFixed(1)} minutes`);sendMessage(o,{status:400,message:"Deposit expired"});stopVerificationSchedule(n.id);await(0,utils_2.updateTransaction)(n.id,{status:"TIMEOUT",description:"Deposit expired. Please try again.",amount:g});return}}function p(e){const t=[/off-?chain transfer\s+(\w+)/i,/офчейн\s+перевод\s+(\w+)/i,/transferência\s+off-chain\s+(\w+)/i,/transferencia\s+off-chain\s+(\w+)/i];for(const o of t){const t=e.match(o);if(t&&t[1])return t[1]}return e}console_1.logger.debug("SPOT_DEPOSIT",`Updating transaction ${n.id} to COMPLETED`);const S=await(0,utils_2.updateTransaction)(n.id,{status:"COMPLETED",description:`Deposit of ${g} ${a.currency} to wallet`,amount:g,fee:f});console_1.logger.debug("SPOT_DEPOSIT",`Updating wallet balance for user ${e}`);const h=await(0,spot_1.updateSpotWalletBalance)(e,a.currency,g,f,"DEPOSIT");if(!h){console_1.logger.error("SPOT_DEPOSIT","Failed to update wallet balance");sendMessage(o,{status:500,message:"Failed to update wallet balance"});stopVerificationSchedule(S.id);return}if("kucoin"===l)try{await c.transfer(a.currency,d.amount,"main","trade");console_1.logger.debug("SPOT_DEPOSIT","Completed KuCoin transfer from main to trade account")}catch(V){console_1.logger.error("SPOT_DEPOSIT",`Transfer failed: ${V.message}`)}const P=await(0,utils_1.getUserById)(e);try{await(0,emails_1.sendSpotWalletDepositConfirmationEmail)(P,S,h,s.chain);await(0,notifications_1.createNotification)({userId:e,relatedId:S.id,type:"system",title:"Deposit Confirmation",message:`Your deposit of ${g} ${a.currency} has been confirmed.`,link:`/finance/wallet/deposit/${S.id}`,actions:[{label:"View Deposit",link:`/finance/wallet/deposit/${S.id}`,primary:!0}]});console_1.logger.debug("SPOT_DEPOSIT","Sent confirmation email and notification")}catch(q){console_1.logger.error("SPOT_DEPOSIT",`Deposit confirmation email failed: ${q.message}`)}try{await(0,affiliate_1.processRewards)(P.id,g,"WELCOME_BONUS",a.currency);console_1.logger.debug("SPOT_DEPOSIT","Processed welcome bonus rewards")}catch(R){console_1.logger.error("SPOT_DEPOSIT",`Error processing rewards: ${R.message}`)}console_1.logger.success("SPOT_DEPOSIT",`Successfully completed deposit ${t} for user ${e}`);sendMessage(o,{status:200,message:"Transaction completed",transaction:S,balance:h.balance,currency:h.currency,chain:s.chain,method:"Wallet Transfer"});stopVerificationSchedule(S.id)}catch(k){console_1.logger.error("SPOT_DEPOSIT",`Error in verifyTransaction: ${k.message}`);sendMessage(o,{status:500,message:`Verification error: ${k.message}`});throw k}}function normalizeTransactionReference(e){const t=e.toLowerCase().trim(),o=["off-chain transfer","offchain transfer","transferencia fuera de cadena"];for(const e of o)if(t.includes(e))return"off-chain transfer";return e}async function getTransactionQuery(e,t){const o=new Date(Date.now()-18e5),r=await db_1.models.transaction.findOne({where:{referenceId:t,userId:e,type:"DEPOSIT",createdAt:{[sequelize_1.Op.gte]:o}},include:[{model:db_1.models.wallet,as:"wallet",attributes:["id","currency"]},{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","email","avatar"]}]});if(!r)throw(0,error_1.createError)({statusCode:404,message:"Transaction not found"});return r.get({plain:!0})}async function deleteTransaction(e){await db_1.models.transaction.destroy({where:{id:e}})}var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.spotVerificationIntervals=exports.metadata=void 0;exports.startSpotVerificationSchedule=startSpotVerificationSchedule;exports.stopVerificationSchedule=stopVerificationSchedule;exports.verifyTransaction=verifyTransaction;exports.getTransactionQuery=getTransactionQuery;exports.deleteTransaction=deleteTransaction;const sequelize_1=require("sequelize"),exchange_1=__importDefault(require("@b/utils/exchange")),Websocket_1=require("@b/handler/Websocket"),error_1=require("@b/utils/error"),affiliate_1=require("@b/utils/affiliate"),utils_1=require("@b/api/user/profile/utils"),emails_1=require("@b/utils/emails"),db_1=require("@b/db"),utils_2=require("../../utils"),notifications_1=require("@b/utils/notifications"),cache_1=require("@b/utils/cache"),console_1=require("@b/utils/console"),spot_1=require("@b/utils/spot"),utils_3=require("./utils"),path="/api/finance/deposit/spot";exports.metadata={};exports.spotVerificationIntervals=new Map;exports.default=async(e,t)=>{const{user:o}=e;if(!(null==o?void 0:o.id))throw(0,error_1.createError)(401,"Unauthorized");"string"==typeof t&&(t=JSON.parse(t));const{trx:r}=t.payload,n=await db_1.models.transaction.findOne({where:{referenceId:r,userId:o.id,type:"DEPOSIT"}});if(!n)return sendMessage(t.payload,{status:404,message:"Transaction not found"});startSpotVerificationSchedule(n.id,o.id,r)};const sendMessage=(e,t)=>{try{Websocket_1.messageBroker.broadcastToSubscribedClients(path,e,{stream:"verification",data:t})}catch(e){console_1.logger.error("SPOT_DEPOSIT",`Failed to send message: ${e}`)}};