"use strict";function generateFileUrl(e){return`/uploads/${e}`}async function ensureDirExists(e){try{await promises_1.default.access(e)}catch(t){if("ENOENT"!==t.code)throw t;await promises_1.default.mkdir(e,{recursive:!0})}}function validateFileSignature(e,t){if(e.length<4)return!1;const i=e.slice(0,12);switch(t){case"image/jpeg":case"image/jpg":return 255===i[0]&&216===i[1]&&255===i[2];case"image/png":return 137===i[0]&&80===i[1]&&78===i[2]&&71===i[3];case"image/gif":return 71===i[0]&&73===i[1]&&70===i[2]&&56===i[3]&&(55===i[4]||57===i[4]);case"image/webp":return 82===i[0]&&73===i[1]&&70===i[2]&&70===i[3]&&87===i[8]&&69===i[9]&&66===i[10]&&80===i[11];case"application/pdf":return 37===i[0]&&80===i[1]&&68===i[2]&&70===i[3];case"application/vnd.openxmlformats-officedocument.wordprocessingml.document":case"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet":case"application/vnd.ms-excel":return 80===i[0]&&75===i[1];case"application/msword":return 208===i[0]&&207===i[1]&&17===i[2]&&224===i[3];case"text/plain":case"text/csv":try{const t=e.toString("utf8");if(t.includes("\0"))return!1;return Buffer.from(t,"utf8").equals(e)}catch(e){return!1}default:return!1}}function getExtensionFromMimeType(e){return{"image/jpeg":".jpg","image/jpg":".jpg","image/png":".png","image/webp":".webp","image/gif":".gif","application/pdf":".pdf","application/msword":".doc","application/vnd.openxmlformats-officedocument.wordprocessingml.document":".docx","application/vnd.ms-excel":".xls","application/vnd.openxmlformats-officedocument.spreadsheetml.sheet":".xlsx","text/plain":".txt","text/csv":".csv"}[e]||".bin"}function isValidExtension(e){return[".jpg",".jpeg",".png",".webp",".gif",".pdf",".doc",".docx",".xls",".xlsx",".txt",".csv"].includes(e.toLowerCase())}async function removeOldFileSecurely(e,t){const i=e.replace(/^(\.\.[/\\])+/,"").replace(/^[/\\]+/,""),r=path_1.default.join(BASE_UPLOAD_DIR,t),o=path_1.default.resolve(BASE_UPLOAD_DIR,i);if(!o.startsWith(r+path_1.default.sep)&&o!==r)throw(0,error_1.createError)({statusCode:403,message:"Forbidden: Attempt to delete file outside upload directory"});try{await promises_1.default.access(o);await promises_1.default.unlink(o)}catch(e){"ENOENT"!==e.code&&console_1.logger.error("KYC","Error removing old file",e)}}var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const error_1=require("@b/utils/error"),query_1=require("@b/utils/query"),promises_1=__importDefault(require("fs/promises")),path_1=__importDefault(require("path")),validation_1=require("@b/utils/validation"),console_1=require("@b/utils/console"),isProduction="production"===process.env.NODE_ENV,BASE_UPLOAD_DIR=isProduction?path_1.default.join(process.cwd(),"frontend","public","uploads"):path_1.default.join(process.cwd(),"..","frontend","public","uploads");exports.metadata={summary:"Uploads a KYC document file",description:"Uploads a KYC document file including PDFs, images, and other document types",operationId:"uploadKycDocument",tags:["Upload","KYC"],requiresAuth:!0,logModule:"KYC",logTitle:"Upload KYC document",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{dir:{type:"string",description:"Directory to upload file to"},file:{type:"string",description:"Base64 encoded file data"},filename:{type:"string",description:"Original filename"},oldPath:{type:"string",description:"Path of the old file to remove"}},required:["dir","file"]}}}},responses:{200:{description:"File uploaded successfully",content:{"application/json":{schema:{type:"object",properties:{url:{type:"string",description:"URL of the uploaded file"},filename:{type:"string",description:"Generated filename"},size:{type:"number",description:"File size in bytes"},mimeType:{type:"string",description:"MIME type of the file"}}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Upload"),500:query_1.serverErrorResponse}};exports.default=async e=>{var t;const{body:i,user:r,ctx:o}=e;if(!r)throw(0,error_1.createError)({statusCode:401,message:"User not found"});try{null==o||o.step("Validating upload request");console_1.logger.debug("KYC",`Document upload request received: dir=${i.dir}, filename=${i.filename}`);const{dir:e,file:r,filename:a,oldPath:s}=i;if(!e||!r){null==o||o.fail("Missing directory or file data");throw(0,error_1.createError)({statusCode:400,message:"No directory specified or no file provided"})}null==o||o.step("Validating directory path security");if("string"!=typeof e||e.length>100){null==o||o.fail("Invalid directory path format");throw(0,error_1.createError)({statusCode:400,message:"Invalid directory path"})}if(e.includes("\0")||e.includes("%00")||e.includes("..")){null==o||o.fail("Directory path contains suspicious patterns");throw(0,error_1.createError)({statusCode:400,message:"Invalid directory path"})}null==o||o.step("Validating file format and encoding");if("string"!=typeof r||!r.startsWith("data:")){null==o||o.fail("Invalid base64 file format");throw(0,error_1.createError)({statusCode:400,message:"Invalid file format"})}const l=r.split(",")[1];if(!l){null==o||o.fail("Missing base64 file data");throw(0,error_1.createError)({statusCode:400,message:"Invalid file data"})}null==o||o.step("Checking file size limits");const n=3*l.length/4;if(n>52428800){null==o||o.fail(`File size ${Math.round(n/1024/1024)}MB exceeds 50MB limit`);throw(0,error_1.createError)({statusCode:400,message:"File size exceeds maximum limit of 50MB"})}null==o||o.step("Sanitizing upload directory path");const d=(0,validation_1.sanitizeUserPath)(e.replace(/-/g,"/")),c=path_1.default.join(BASE_UPLOAD_DIR,d),p=path_1.default.resolve(c),u=path_1.default.resolve(BASE_UPLOAD_DIR);if(!p.startsWith(u+path_1.default.sep)&&p!==u){null==o||o.fail("Upload directory outside allowed path");throw(0,error_1.createError)({statusCode:400,message:"Invalid upload directory"})}null==o||o.step("Creating upload directory if needed");await ensureDirExists(c);null==o||o.step("Validating MIME type");const f=(null===(t=r.match(/^data:(.*);base64,/))||void 0===t?void 0:t[1])||"";if(!["image/jpeg","image/jpg","image/png","image/webp","image/gif","application/pdf","application/msword","application/vnd.openxmlformats-officedocument.wordprocessingml.document","application/vnd.ms-excel","application/vnd.openxmlformats-officedocument.spreadsheetml.sheet","text/plain","text/csv"].includes(f)){null==o||o.fail(`MIME type ${f} not allowed`);throw(0,error_1.createError)({statusCode:400,message:`File type ${f} not allowed for KYC documents`})}null==o||o.step("Decoding file data");const m=Buffer.from(l,"base64");console_1.logger.debug("KYC",`File validation - MIME type: ${f}, Buffer length: ${m.length}`);null==o||o.step("Validating file signature against MIME type");const g=validateFileSignature(m,f);console_1.logger.debug("KYC",`File signature validation result: ${g}`);if(!g){if(!f.startsWith("image/")){null==o||o.fail("File signature does not match MIME type");throw(0,error_1.createError)({statusCode:400,message:"File content does not match declared MIME type. Potential security threat detected."})}console_1.logger.debug("KYC","Image type detected, allowing despite magic number mismatch")}null==o||o.step("Generating secure filename");const h=Date.now(),_=Math.round(1e9*Math.random());let y=getExtensionFromMimeType(f);if(!y&&a){const e=path_1.default.extname(a).toLowerCase();e&&isValidExtension(e)&&(y=e)}const v=`${h}-${_}${y}`,w=path_1.default.join(c,v);null==o||o.step("Writing file to disk");await promises_1.default.writeFile(w,m);if(s){null==o||o.step("Removing old file");try{await removeOldFileSecurely(s,d)}catch(e){console_1.logger.error("KYC","Error removing old file",e)}}const x={url:generateFileUrl(`${d.replace(/\\/g,"/")}/${v}`),filename:v,size:n,mimeType:f};null==o||o.success(`Document uploaded successfully: ${v}`);console_1.logger.debug("KYC",`Document upload successful: ${x.filename}`);return x}catch(e){null==o||o.fail(`Document upload failed: ${e.message}`);console_1.logger.error("KYC","Document upload error",e);throw e}};