"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const error_1=require("@b/utils/error"),db_1=require("@b/db"),console_1=require("@b/utils/console");exports.metadata={summary:"Disconnects a wallet address for the user",description:"Disconnects a wallet address for the authenticated user and removes the record from providerUser",operationId:"disconnectWallet",tags:["Auth"],requiresAuth:!0,logModule:"WALLET",logTitle:"Disconnect wallet",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{address:{type:"string",description:"Wallet address"}},required:["address"]}}}},responses:{200:{description:"Wallet address disconnected successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Success message"}}}}}},400:{description:"Invalid request (e.g., missing address)"},401:{description:"Unauthorized (e.g., user not authenticated)"},500:{description:"Internal server error"}}};exports.default=async e=>{const{body:r,user:s,ctx:t}=e,{address:o}=r;if(!(null==s?void 0:s.id)){null==t||t.fail("User not authenticated");throw(0,error_1.createError)({statusCode:401,message:"User not authenticated"})}if(!o){null==t||t.fail("Address missing");throw(0,error_1.createError)({statusCode:400,message:"Address is required"})}try{null==t||t.step("Finding wallet connection");const e=await db_1.models.providerUser.findOne({where:{providerUserId:o,userId:s.id}});if(!e){null==t||t.fail("Wallet not registered");throw(0,error_1.createError)({statusCode:400,message:"Wallet not registered"})}null==t||t.step("Disconnecting wallet");await e.destroy({force:!0});null==t||t.success("Wallet disconnected successfully");return{message:"Wallet address disconnected successfully"}}catch(e){console_1.logger.error("USER","Error disconnecting wallet",e);null==t||t.fail("Failed to disconnect wallet");throw(0,error_1.createError)({statusCode:500,message:"Internal server error"})}};