"use strict";function parseSubscription(e){try{const s=JSON.parse(e);if(s&&"string"==typeof s.endpoint&&s.endpoint.startsWith("https://")&&s.keys&&"string"==typeof s.keys.p256dh&&"string"==typeof s.keys.auth)return s}catch(e){}return null}function getFirstSubscription(e){if(!e)return null;if(e.pushTokens)if("object"!=typeof e.pushTokens||Array.isArray(e.pushTokens)){if(Array.isArray(e.pushTokens))for(const s of e.pushTokens)if("string"==typeof s){const e=parseSubscription(s);if(e)return e}else if(s&&"object"==typeof s&&s.token){const e=parseSubscription(s.token);if(e)return e}}else for(const[s,t]of Object.entries(e.pushTokens))if("string"==typeof t){const e=parseSubscription(t);if(e)return{...e,deviceId:s}}else if(t&&"object"==typeof t){const e=t;if(e.token){const t=parseSubscription(e.token);if(t)return{...t,deviceId:s}}}return null}var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const web_push_1=__importDefault(require("web-push")),errors_1=require("@b/utils/schema/errors"),db_1=require("@b/db");exports.metadata={summary:"Direct Push Test",description:"Send a push notification directly (for debugging)",operationId:"testDirectPush",tags:["User","Push","Testing"],requiresAuth:!0,responses:{200:{description:"Direct push test result",content:{"application/json":{schema:{type:"object",properties:{success:{type:"boolean"},message:{type:"string"},details:{type:"object"}}}}}},401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse}};exports.default=async e=>{var s;const{user:t}=e;if(!(null==t?void 0:t.id))throw new Error("User not authenticated");const i=process.env.VAPID_PUBLIC_KEY,o=process.env.VAPID_PRIVATE_KEY,n=process.env.VAPID_SUBJECT||`mailto:${process.env.APP_NODEMAILER_SMTP_SENDER||"admin@example.com"}`;if(!i||!o)return{success:!1,message:"VAPID keys not configured",details:{hasPublicKey:!!i,hasPrivateKey:!!o}};const r=await db_1.models.user.findByPk(t.id,{attributes:["settings"]}),u=getFirstSubscription(null==r?void 0:r.settings);if(!u)return{success:!1,message:"No WebPush subscription found",details:{settingsKeys:Object.keys((null==r?void 0:r.settings)||{})}};console.log("[Direct Push] Subscription found:",{endpoint:null===(s=u.endpoint)||void 0===s?void 0:s.substring(0,80),deviceId:u.deviceId,hasKeys:!!u.keys});web_push_1.default.setVapidDetails(n,i,o);const a=JSON.stringify({title:"🔔 Direct Push Test",body:`Test at ${(new Date).toLocaleTimeString()} - If you see this, push is working!`,icon:"/icon-192x192.png",badge:"/badge-72x72.png",tag:"direct-test-"+Date.now(),renotify:!0,data:{url:"/user/profile?tab=notifications",testMode:!0,timestamp:Date.now()}}),c=u.endpoint.includes("fcm.googleapis.com");console.log("[Direct Push] Sending with:",{isFCM:c,payloadSize:a.length,endpoint:u.endpoint.substring(0,80)});try{const e=await web_push_1.default.sendNotification({endpoint:u.endpoint,keys:u.keys},a,{TTL:60,urgency:"high"});console.log("[Direct Push] Success:",{statusCode:e.statusCode,headers:e.headers});return{success:!0,message:"Push sent successfully! Check your device.",details:{statusCode:e.statusCode,isFCM:c,endpoint:u.endpoint.substring(0,50)+"...",payloadSize:a.length}}}catch(e){console.error("[Direct Push] Error:",e);return 410===e.statusCode||404===e.statusCode?{success:!1,message:"Subscription is expired or invalid. Please re-enable push notifications.",details:{statusCode:e.statusCode,shouldResubscribe:!0}}:{success:!1,message:e.message||"Failed to send push",details:{statusCode:e.statusCode,body:e.body,endpoint:u.endpoint.substring(0,50)+"..."}}}};