"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const db_1=require("@b/db"),safe_imports_1=require("@b/utils/safe-imports"),notifications_1=require("@b/utils/notifications"),console_1=require("@b/utils/console"),error_1=require("@b/utils/error"),BTC_NODE=(process.env.BTC_NODE||"mempool").toLowerCase(),BLOCKCYPHER_TOKEN=process.env.BLOCKCYPHER_TOKEN,SCAN_INTERVAL=6e4,REQUIRED_CONFIRMATIONS=3;class BTCDepositScanner{constructor(){this.isScanning=!1;this.processedTransactions=new Map;this.provider=null;this.providerType=null;this.scanInterval=null;this.ecosystemWalletUtils=null;this.initializationFailed=!1;this.isInitialized=!1}static getInstance(){BTCDepositScanner.instance||(BTCDepositScanner.instance=new BTCDepositScanner);return BTCDepositScanner.instance}async initializeProviderWithFallback(){const e=[];switch(BTC_NODE){case"node":e.push("node");e.push("mempool");BLOCKCYPHER_TOKEN&&e.push("blockcypher");break;case"blockcypher":BLOCKCYPHER_TOKEN&&e.push("blockcypher");e.push("mempool");break;default:e.push("mempool");BLOCKCYPHER_TOKEN&&e.push("blockcypher")}for(const s of e)try{if(await this.tryInitializeProvider(s)){this.providerType=s;return!0}}catch(e){console_1.logger.groupItem("BTC_SCAN",`${s} failed: ${e instanceof Error?e.message:e}`,"error")}return!1}async tryInitializeProvider(e){switch(e){case"node":{console_1.logger.groupItem("BTC_SCAN","Trying local Bitcoin Core node...");const e=await(0,safe_imports_1.getBitcoinNodeService)();if(!(0,safe_imports_1.isServiceAvailable)(e))throw(0,error_1.createError)({statusCode:500,message:"Bitcoin Node service not available"});console_1.logger.groupItem("BTC_SCAN","Initializing BTC Core RPC connection");this.provider=await e.getInstance();if(!await this.provider.isSynced()){const e=await this.provider.getSyncProgress();console_1.logger.groupItem("BTC_SCAN",`Node syncing: ${e.blocks}/${e.headers} (${e.progress.toFixed(1)}%)`,"warn")}console_1.logger.groupItem("BTC_SCAN","Local node connected","success");return!0}case"mempool":{console_1.logger.groupItem("BTC_SCAN","Trying Mempool.space API...");const e=await(0,safe_imports_1.getMempoolProviderClass)();if(!(0,safe_imports_1.isServiceAvailable)(e))throw(0,error_1.createError)({statusCode:500,message:"Mempool provider not available"});const s=new e("BTC");if(!await s.isAvailable())throw(0,error_1.createError)({statusCode:500,message:"Mempool.space API not reachable"});this.provider=s;console_1.logger.groupItem("BTC_SCAN","Mempool.space connected","success");return!0}case"blockcypher":{if(!BLOCKCYPHER_TOKEN)throw(0,error_1.createError)({statusCode:500,message:"BLOCKCYPHER_TOKEN not configured"});console_1.logger.groupItem("BTC_SCAN","Trying BlockCypher API...");const e=await(0,safe_imports_1.getBlockCypherProviderClass)();if(!(0,safe_imports_1.isServiceAvailable)(e))throw(0,error_1.createError)({statusCode:500,message:"BlockCypher provider not available"});const s=new e("BTC");if(!await s.isAvailable())throw(0,error_1.createError)({statusCode:500,message:"BlockCypher API not reachable"});this.provider=s;console_1.logger.groupItem("BTC_SCAN","BlockCypher connected","success");return!0}default:return!1}}async start(){if(!this.isInitialized&&!this.initializationFailed){this.ecosystemWalletUtils=await(0,safe_imports_1.getEcosystemWalletUtils)();if((0,safe_imports_1.isServiceAvailable)(this.ecosystemWalletUtils)){console_1.logger.group("BTC_SCAN","Starting Bitcoin deposit scanner...");console_1.logger.registerGroupAlias("BTC_NODE","BTC_SCAN");console_1.logger.registerGroupAlias("BTC_NODE_PROVIDER","BTC_SCAN");try{if(!await this.initializeProviderWithFallback())throw(0,error_1.createError)({statusCode:500,message:"All providers failed - no BTC scanning available"});"node"===this.providerType&&await this.importAllAddresses();this.startPeriodicScan();this.isInitialized=!0;console_1.logger.groupEnd("BTC_SCAN",`Scanner started using ${this.providerType}`,!0)}catch(e){this.initializationFailed=!0;console_1.logger.groupEnd("BTC_SCAN",`Failed: ${e instanceof Error?e.message:e}`,!1);"node"===BTC_NODE?console_1.logger.warn("BTC_SCAN","Tip: Ensure Bitcoin Core is running or set BTC_NODE=mempool in .env"):console_1.logger.warn("BTC_SCAN","Tip: Check your internet connection or try a different BTC_NODE provider")}finally{console_1.logger.unregisterGroupAlias("BTC_NODE");console_1.logger.unregisterGroupAlias("BTC_NODE_PROVIDER")}}}}stop(){if(this.scanInterval){clearInterval(this.scanInterval);this.scanInterval=null}this.isInitialized&&console_1.logger.info("BTC_SCAN","Bitcoin deposit scanner stopped");this.isInitialized=!1}async importAllAddresses(){var e,s;if("node"===this.providerType&&(null===(e=this.provider)||void 0===e?void 0:e.importAddress))try{console_1.logger.groupItem("BTC_SCAN","Importing wallet addresses to node...");const e=await db_1.models.wallet.findAll({where:{type:"ECO",currency:"BTC"}});console_1.logger.groupItem("BTC_SCAN",`Found ${e.length} BTC wallets`);let o=0;for(const t of e)try{if(!t.address)continue;const e="string"==typeof t.address?JSON.parse(t.address):t.address,i=null===(s=null==e?void 0:e.BTC)||void 0===s?void 0:s.address;if(!i)continue;await this.provider.importAddress(i,`wallet_${t.id}_user_${t.userId}`);o++;await this.delay(100)}catch(e){}o>0&&console_1.logger.groupItem("BTC_SCAN",`Imported ${o} addresses`,"success")}catch(e){console_1.logger.groupItem("BTC_SCAN",`Address import failed: ${e instanceof Error?e.message:e}`,"warn")}}startPeriodicScan(){this.scanInterval=setInterval(async()=>{await this.scanAllWallets()},6e4);setImmediate(()=>this.scanAllWallets())}async scanAllWallets(){if(!this.isScanning&&this.provider){if("node"===this.providerType&&this.provider.isSynced){if(!await this.provider.isSynced())return}this.isScanning=!0;try{const e=await db_1.models.wallet.findAll({where:{type:"ECO",currency:"BTC"}});let s=0,o=0;for(const t of e)try{const e=await this.scanWalletForDeposits(t);s+=e.newDeposits;o+=e.pendingDeposits}catch(e){console_1.logger.error("BTC_SCAN",`Error scanning wallet ${t.id}`,e)}(s>0||o>0)&&console_1.logger.info("BTC_SCAN",`Scan completed: ${s} new, ${o} pending`)}catch(e){console_1.logger.error("BTC_SCAN","Error in scan cycle",e)}finally{this.isScanning=!1}}}async scanWalletForDeposits(e){var s;try{if(!e.address)return{newDeposits:0,pendingDeposits:0};const o="string"==typeof e.address?JSON.parse(e.address):e.address,t=null===(s=null==o?void 0:o.BTC)||void 0===s?void 0:s.address;if(!t)return{newDeposits:0,pendingDeposits:0};let i=[];i="node"===this.providerType?await this.provider.getAddressTransactions(t):await this.provider.fetchTransactions(t);let r=0,n=0;for(const s of i){const o=s.txid||s.hash,i=s.confirmations||0;if("receive"!==(s.category||(s.value>0?"receive":"send"))&&s.value<=0)continue;const a=`${o}-${e.id}`,l=await db_1.models.transaction.findOne({where:{trxId:o,walletId:e.id,type:"DEPOSIT"}});if(l&&"COMPLETED"===l.status)this.processedTransactions.set(a,{txid:o,walletId:e.id,lastChecked:Date.now()});else if(i>=3){console_1.logger.info("BTC_SCAN",`Processing deposit: ${o} (${i} conf)`);await this.processDeposit(e,s,t);r++;this.processedTransactions.set(a,{txid:o,walletId:e.id,lastChecked:Date.now()})}else i>0&&n++}return{newDeposits:r,pendingDeposits:n}}catch(s){console_1.logger.error("BTC_SCAN",`Error scanning wallet ${e.id}`,s);return{newDeposits:0,pendingDeposits:0}}}async processDeposit(e,s,o){try{const t=s.txid||s.hash,i=s.amount||s.value/1e8,r=s.fee||0,n={id:e.id,chain:"BTC",hash:t,type:"DEPOSIT",from:"N/A",to:o,amount:i.toString(),fee:r.toString(),status:"CONFIRMED",timestamp:s.time||s.confirmedTime||Math.floor(Date.now()/1e3),inputs:s.vin||s.inputs||[],outputs:s.vout||s.outputs||[]};console_1.logger.info("BTC_SCAN",`Creating deposit: ${i} BTC`);const a=await this.ecosystemWalletUtils.handleEcosystemDeposit(n);if(a.transaction){console_1.logger.success("BTC_SCAN",`Deposit processed: ${a.transaction.id}`);try{await(0,notifications_1.createNotification)({userId:e.userId,relatedId:a.transaction.id,title:"Deposit Confirmed",message:`Your deposit of ${i} BTC has been confirmed.`,type:"system",link:"/finance/history",actions:[{label:"View Deposit",link:"/finance/history",primary:!0}]})}catch(e){console_1.logger.error("BTC_SCAN","Failed to send notification",e)}}}catch(e){const o=s.txid||s.hash;console_1.logger.error("BTC_SCAN",`Failed to process deposit ${o}`,e);throw e}}delay(e){return new Promise(s=>setTimeout(s,e))}}exports.default=BTCDepositScanner;