"use strict";var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.redisCache=exports.RedisCache=void 0;const ioredis_1=__importDefault(require("ioredis"));class RedisCache{constructor(){this.redis=new ioredis_1.default({host:process.env.REDIS_HOST||"127.0.0.1",port:parseInt(process.env.REDIS_PORT||"6379"),password:process.env.REDIS_PASSWORD||void 0,retryStrategy:e=>Math.min(50*e,2e3)});this.redis.on("error",e=>{console.error("[RedisCache] Connection error:",e)})}static getInstance(){RedisCache.instance||(RedisCache.instance=new RedisCache);return RedisCache.instance}getClient(){return this.redis}async getUserPreferences(e){try{const r=await this.redis.get(`user:prefs:${e}`);return r?JSON.parse(r):null}catch(r){console.error(`[RedisCache] Error getting user preferences for ${e}:`,r);return null}}async setUserPreferences(e,r){try{await this.redis.setex(`user:prefs:${e}`,3600,JSON.stringify(r))}catch(r){console.error(`[RedisCache] Error setting user preferences for ${e}:`,r)}}async clearUserPreferences(e){try{await this.redis.del(`user:prefs:${e}`)}catch(r){console.error(`[RedisCache] Error clearing user preferences for ${e}:`,r)}}async checkIdempotency(e){try{return await this.redis.get(`notif:idem:${e}`)}catch(r){console.error(`[RedisCache] Error checking idempotency for ${e}:`,r);return null}}async setIdempotency(e,r){try{await this.redis.setex(`notif:idem:${e}`,86400,r)}catch(r){console.error(`[RedisCache] Error setting idempotency for ${e}:`,r)}}async trackDelivery(e,r,t){try{const s=`notif:delivery:${e}`,i=await this.redis.get(s),a=i?JSON.parse(i):{};a[r]={...t,timestamp:(new Date).toISOString()};await this.redis.setex(s,2592e3,JSON.stringify(a))}catch(r){console.error(`[RedisCache] Error tracking delivery for ${e}:`,r)}}async getDeliveryStatus(e){try{const r=await this.redis.get(`notif:delivery:${e}`);return r?JSON.parse(r):null}catch(r){console.error(`[RedisCache] Error getting delivery status for ${e}:`,r);return null}}async incrementStat(e,r=1){try{await this.redis.hincrby("notif:stats:hourly",e,r);-1===await this.redis.ttl("notif:stats:hourly")&&await this.redis.expire("notif:stats:hourly",3600)}catch(r){console.error(`[RedisCache] Error incrementing stat ${e}:`,r)}}async getStats(){try{return await this.redis.hgetall("notif:stats:hourly")||{}}catch(e){console.error("[RedisCache] Error getting stats:",e);return{}}}async getFormattedMetrics(){const e=await this.getStats(),r=parseInt(e.sent||"0"),t=parseInt(e.failed||"0"),s=r+t,i=s>0?r/s*100:0,a={};for(const[r,t]of Object.entries(e))if(r.startsWith("channels:")){a[r.replace("channels:","")]=parseInt(t)}return{sent:r,failed:t,successRate:parseFloat(i.toFixed(2)),channels:a}}async resetHourlyStats(){try{await this.redis.del("notif:stats:hourly")}catch(e){console.error("[RedisCache] Error resetting stats:",e)}}async isConnected(){try{await this.redis.ping();return!0}catch(e){return!1}}async getCacheHitRate(){try{const e=await this.redis.info("stats"),r=e.match(/keyspace_hits:(\d+)/),t=r?parseInt(r[1]):0,s=e.match(/keyspace_misses:(\d+)/),i=t+(s?parseInt(s[1]):0);return i>0?t/i*100:0}catch(e){console.error("[RedisCache] Error getting hit rate:",e);return 0}}async close(){await this.redis.quit()}}exports.RedisCache=RedisCache;exports.redisCache=RedisCache.getInstance();