"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.NodemailerProvider=void 0;const BaseEmailProvider_1=require("./BaseEmailProvider"),nodemailer=require("nodemailer");class NodemailerProvider extends BaseEmailProvider_1.BaseEmailProvider{constructor(e){super("Nodemailer",e);this.validateConfig()&&this.initializeTransporter()}loadConfigFromEnv(){const e=process.env.APP_NODEMAILER_SERVICE;return{service:e,host:process.env.APP_NODEMAILER_SMTP_HOST,port:parseInt(process.env.APP_NODEMAILER_SMTP_PORT||"587"),secure:"ssl"===process.env.APP_NODEMAILER_SMTP_ENCRYPTION,auth:{user:e?process.env.APP_NODEMAILER_SERVICE_SENDER:process.env.APP_NODEMAILER_SMTP_USERNAME||process.env.APP_NODEMAILER_SMTP_SENDER,pass:e?process.env.APP_NODEMAILER_SERVICE_PASSWORD:process.env.APP_NODEMAILER_SMTP_PASSWORD},from:process.env.NEXT_PUBLIC_APP_EMAIL||process.env.APP_EMAIL_FROM||"noreply@example.com",fromName:process.env.APP_EMAIL_SENDER_NAME||"Notification Service"}}validateConfig(){if(!this.config.service&&!this.config.host){this.logError("Missing SMTP service or host configuration",{});return!1}if(!this.config.auth||!this.config.auth.user||!this.config.auth.pass){this.logError("Missing SMTP authentication credentials",{});return!1}return!0}initializeTransporter(){try{const e={auth:this.config.auth};if(this.config.service)e.service=this.config.service;else if(this.config.host){e.host=this.config.host;e.port=this.config.port;e.secure=this.config.secure}this.transporter=nodemailer.createTransport(e);this.log("Transporter initialized successfully")}catch(e){this.logError("Failed to initialize transporter",e);throw e}}async send(e){try{if(!this.validateConfig()||!this.transporter)throw new Error("Nodemailer configuration is invalid or transporter not initialized");const r={from:e.from||this.formatEmail(this.config.from,this.config.fromName),to:Array.isArray(e.to)?e.to.join(", "):e.to,subject:e.subject,html:e.html,text:e.text||this.stripHtml(e.html)};e.replyTo&&(r.replyTo=e.replyTo);e.cc&&e.cc.length>0&&(r.cc=e.cc.join(", "));e.bcc&&e.bcc.length>0&&(r.bcc=e.bcc.join(", "));e.attachments&&e.attachments.length>0&&(r.attachments=e.attachments);const t=await this.transporter.sendMail(r);this.log("Email sent successfully",{to:e.to,subject:e.subject,messageId:t.messageId});return{success:!0,externalId:t.messageId,messageId:`nodemailer-${t.messageId}`}}catch(e){this.logError("Failed to send email",e);return{success:!1,error:e.message||"Failed to send email via Nodemailer"}}}stripHtml(e){return e.replace(/<[^>]*>/g,"").replace(/&nbsp;/g," ").replace(/&amp;/g,"&").replace(/&lt;/g,"<").replace(/&gt;/g,">").trim()}async verifyConnection(){try{await this.transporter.verify();this.log("Connection verified successfully");return!0}catch(e){this.logError("Connection verification failed",e);return!1}}}exports.NodemailerProvider=NodemailerProvider;