"use strict";function roundToPrecision(e,t){const r=(0,constants_1.getPrecision)(t),n=Math.pow(10,r);return Math.round(e*n)/n}function validatePrecision(e,t){const r=(0,constants_1.getPrecision)(t),n=Math.pow(10,r),a=Math.round(e*n);return Math.abs(e*n-a)<1e-7}function safeAdd(e,t,r){const n=(0,constants_1.getPrecision)(r),a=Math.pow(10,n);return(Math.round(e*a)+Math.round(t*a))/a}function safeSubtract(e,t,r){const n=(0,constants_1.getPrecision)(r),a=Math.pow(10,n);return(Math.round(e*a)-Math.round(t*a))/a}function safeMultiply(e,t,r){const n=(0,constants_1.getPrecision)(r),a=Math.pow(10,n);return Math.round(e*t*a)/a}function safeDivide(e,t,r){if(0===t)throw(0,error_1.createError)({statusCode:400,message:"Division by zero"});const n=(0,constants_1.getPrecision)(r),a=Math.pow(10,n);return Math.round(e/t*a)/a}function safeEquals(e,t,r=1e-8){return Math.abs(e-t)<r}function safeGreaterThan(e,t,r=1e-8){return e-t>r}function safeGreaterThanOrEqual(e,t,r=1e-8){return e-t>=-r}function safeLessThan(e,t,r=1e-8){return t-e>r}function safeLessThanOrEqual(e,t,r=1e-8){return t-e>=-r}function toSmallestUnit(e,t){const r=(0,constants_1.getPrecision)(t),n=Math.pow(10,r);return BigInt(Math.round(e*n))}function fromSmallestUnit(e,t){const r=(0,constants_1.getPrecision)(t),n=Math.pow(10,r);return Number(e)/n}function formatWithPrecision(e,t){const r=(0,constants_1.getPrecision)(t);return e.toFixed(r)}function parseWithPrecision(e,t){const r=parseFloat(e);if(isNaN(r))throw(0,error_1.createError)({statusCode:400,message:`Invalid number: ${e}`});return roundToPrecision(r,t)}function calculatePercentage(e,t,r){return safeMultiply(e,t/100,r)}function calculateFee(e,t,r){return calculatePercentage(e,t,r)}function calculateAmountAfterFee(e,t,r){const n=calculateFee(e,t,r);return{netAmount:safeSubtract(e,n,r),feeAmount:n}}function clamp(e,t,r){return Math.max(t,Math.min(r,e))}function ensureNonNegative(e){return Math.max(0,e)}function safeSum(e,t){return e.reduce((e,r)=>safeAdd(e,r,t),0)}Object.defineProperty(exports,"__esModule",{value:!0});exports.roundToPrecision=roundToPrecision;exports.validatePrecision=validatePrecision;exports.safeAdd=safeAdd;exports.safeSubtract=safeSubtract;exports.safeMultiply=safeMultiply;exports.safeDivide=safeDivide;exports.safeEquals=safeEquals;exports.safeGreaterThan=safeGreaterThan;exports.safeGreaterThanOrEqual=safeGreaterThanOrEqual;exports.safeLessThan=safeLessThan;exports.safeLessThanOrEqual=safeLessThanOrEqual;exports.toSmallestUnit=toSmallestUnit;exports.fromSmallestUnit=fromSmallestUnit;exports.formatWithPrecision=formatWithPrecision;exports.parseWithPrecision=parseWithPrecision;exports.calculatePercentage=calculatePercentage;exports.calculateFee=calculateFee;exports.calculateAmountAfterFee=calculateAmountAfterFee;exports.clamp=clamp;exports.ensureNonNegative=ensureNonNegative;exports.safeSum=safeSum;const error_1=require("@b/utils/error"),constants_1=require("../constants");